/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AnimalEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "animal");
    private int chance;
    private AxisAlignedBB bb;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(world, pos, 30);
        if (aura < 1500000) {
            return false;
        }
        this.chance = Math.min(50, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 500000.0f / (float)IAuraChunk.getSpotAmountInArea(world, pos, 30))));
        if (this.chance <= 0) {
            return false;
        }
        int dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 150000), (int)5, (int)35);
        this.bb = new AxisAlignedBB(pos).func_186662_g((double)dist);
        return true;
    }

    @Override
    public int isActiveHere(EntityPlayer player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return -1;
        }
        if (!this.bb.func_72318_a(player.func_174791_d())) {
            return -1;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_180425_c(), NAME)) {
            return 0;
        }
        return 1;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack(Items.field_151110_aK);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        List animals = world.func_72872_a(EntityAnimal.class, this.bb);
        if (animals.size() >= 200) {
            return;
        }
        if (world.func_82737_E() % 200L == 0L) {
            List items = world.func_72872_a(EntityItem.class, this.bb);
            for (EntityItem item : items) {
                int age;
                ItemStack stack;
                if (item.field_70128_L || !NaturesAuraAPI.instance().isEffectPowderActive(world, item.func_180425_c(), NAME) || !((stack = item.func_92059_d()).func_77973_b() instanceof ItemEgg) || (age = ((Integer)ReflectionHelper.getPrivateValue(EntityItem.class, (Object)item, (String[])new String[]{"field_70292_b", "age"})).intValue()) < item.lifespan / 2) continue;
                if (stack.func_190916_E() <= 1) {
                    item.func_70106_y();
                } else {
                    stack.func_190918_g(1);
                    item.func_92058_a(stack);
                }
                EntityChicken chicken = new EntityChicken(world);
                chicken.func_70873_a(-24000);
                chicken.func_70107_b(item.field_70165_t, item.field_70163_u, item.field_70161_v);
                world.func_72838_d((Entity)chicken);
                BlockPos closestSpot = IAuraChunk.getHighestSpot(world, item.func_180425_c(), 35, pos);
                IAuraChunk.getAuraChunk(world, closestSpot).drainAura(closestSpot, 2000);
            }
        }
        if (world.field_73012_v.nextInt(200) <= this.chance) {
            if (animals.size() < 2) {
                return;
            }
            EntityAnimal first = (EntityAnimal)animals.get(world.field_73012_v.nextInt(animals.size()));
            if (first.func_70631_g_() || first.func_70880_s()) {
                return;
            }
            if (!NaturesAuraAPI.instance().isEffectPowderActive(world, first.func_180425_c(), NAME)) {
                return;
            }
            Optional<EntityAnimal> secondOptional = animals.stream().filter(e -> e != first && !e.func_70880_s() && !e.func_70631_g_()).min(Comparator.comparingDouble(e -> e.func_70068_e((Entity)first)));
            if (!secondOptional.isPresent()) {
                return;
            }
            EntityAnimal second = secondOptional.get();
            if (second.func_70068_e((Entity)first) > 25.0) {
                return;
            }
            this.setInLove(first);
            this.setInLove(second);
            BlockPos closestSpot = IAuraChunk.getHighestSpot(world, first.func_180425_c(), 35, pos);
            IAuraChunk.getAuraChunk(world, closestSpot).drainAura(closestSpot, 3500);
        }
    }

    private void setInLove(EntityAnimal animal) {
        animal.func_146082_f(null);
        for (int j = 0; j < 7; ++j) {
            animal.field_70170_p.func_175688_a(EnumParticleTypes.HEART, animal.field_70165_t + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, animal.field_70163_u + 0.5 + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.field_70131_O), animal.field_70161_v + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, animal.field_70170_p.field_73012_v.nextGaussian() * 0.02, animal.field_70170_p.field_73012_v.nextGaussian() * 0.02, animal.field_70170_p.field_73012_v.nextGaussian() * 0.02, new int[0]);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return ModConfig.enabledFeatures.animalEffect;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

