/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.BlockEnderCrate;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityEnderCrate
extends TileEntityImpl {
    private final IItemHandlerModifiable wrappedEnderStorage = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.getStorage().setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.getStorage().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.getStorage().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack remain = this.getStorage().insertItem(slot, stack, simulate);
            if (!simulate) {
                TileEntityEnderCrate.this.drainAura((stack.func_190916_E() - remain.func_190916_E()) * 500);
            }
            return remain;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack extracted = this.getStorage().extractItem(slot, amount, simulate);
            if (!simulate) {
                TileEntityEnderCrate.this.drainAura(extracted.func_190916_E() * 500);
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return this.getStorage().getSlotLimit(slot);
        }

        private IItemHandlerModifiable getStorage() {
            return IWorldData.getOverworldData(TileEntityEnderCrate.this.field_145850_b).getEnderStorage(TileEntityEnderCrate.this.name);
        }
    };
    public String name;

    @Override
    public IItemHandlerModifiable getItemHandler(EnumFacing facing) {
        if (this.canOpen()) {
            return this.wrappedEnderStorage;
        }
        return null;
    }

    public boolean canOpen() {
        return this.name != null;
    }

    @Override
    public void dropInventory() {
    }

    @Override
    public ItemStack getDrop(IBlockState state, int fortune) {
        ItemStack drop = super.getDrop(state, fortune);
        if (this.name != null) {
            if (!drop.func_77942_o()) {
                drop.func_77982_d(new NBTTagCompound());
            }
            drop.func_77978_p().func_74778_a("naturesaura:ender_name", this.name);
        }
        return drop;
    }

    @Override
    public void loadDataOnPlace(ItemStack stack) {
        String name;
        super.loadDataOnPlace(stack);
        if (!this.field_145850_b.field_72995_K && (name = BlockEnderCrate.getEnderName(stack)) != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    @Override
    public void writeNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK && this.name != null) {
            compound.func_74778_a("name", this.name);
        }
    }

    @Override
    public void readNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK && compound.func_74764_b("name")) {
            this.name = compound.func_74779_i("name");
        }
    }

    public void drainAura(int amount) {
        if (amount > 0) {
            BlockPos spot = IAuraChunk.getHighestSpot(this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
            IAuraChunk.getAuraChunk(this.field_145850_b, spot).drainAura(spot, amount);
        }
    }
}

