/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityProjectileGenerator;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderProjectileGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockProjectileGenerator
extends BlockContainerImpl
implements ITESRProvider {
    public BlockProjectileGenerator() {
        super(Material.field_151576_e, "projectile_generator", TileEntityProjectileGenerator.class, "projectile_generator");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.5f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult ray = event.getRayTraceResult();
        BlockPos pos = ray.func_178782_a();
        if (pos == null) {
            return;
        }
        TileEntity tile = entity.field_70170_p.func_175625_s(pos);
        if (!(tile instanceof TileEntityProjectileGenerator)) {
            return;
        }
        TileEntityProjectileGenerator generator = (TileEntityProjectileGenerator)tile;
        if (generator.nextSide != ray.field_178784_b) {
            return;
        }
        ResourceLocation name = EntityList.func_191301_a((Entity)entity);
        Integer amount = NaturesAuraAPI.PROJECTILE_GENERATIONS.get(name);
        if (amount == null || amount <= 0) {
            return;
        }
        BlockPos spot = IAuraChunk.getLowestSpot(entity.field_70170_p, pos, 35, pos);
        IAuraChunk.getAuraChunk(entity.field_70170_p, spot).storeAura(spot, amount);
        PacketHandler.sendToAllAround(entity.field_70170_p, pos, 32, new PacketParticles((float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, 26, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        entity.field_70170_p.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187528_aR, SoundCategory.BLOCKS, 0.8f, 1.0f);
        generator.nextSide = generator.nextSide.func_176746_e();
        generator.sendToClients();
        entity.func_70106_y();
        event.setCanceled(true);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Tuple<Class, TileEntitySpecialRenderer> getTESR() {
        return new Tuple(TileEntityProjectileGenerator.class, (Object)new RenderProjectileGenerator());
    }
}

