/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.world;

import be.nevoka.morerefinedstorage.world.generatorStructures;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ModWorld
implements IWorldGenerator {
    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ModWorld(), (int)0);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateOverworld(world, rand, blockX + 8, blockZ + 8);
            }
        }
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        if ((int)(Math.random() * 100.0) == 0) {
            int y = ModWorld.getGroundFromAbove(world, blockX, blockZ);
            BlockPos pos = new BlockPos(blockX, y, blockZ);
            generatorStructures structure = new generatorStructures();
            structure.func_180709_b(world, rand, pos);
        }
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 63) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150346_d || blockAt == Blocks.field_150349_c || blockAt == Blocks.field_150354_m || blockAt == Blocks.field_150433_aE;
        }
        return y;
    }

    public static boolean canSpawnHere(Template template, World world, BlockPos posAboveGround) {
        int zwidth = template.func_186259_a().func_177952_p();
        int xwidth = template.func_186259_a().func_177958_n();
        boolean corner1 = ModWorld.isCornerValid(world, posAboveGround);
        boolean corner2 = ModWorld.isCornerValid(world, posAboveGround.func_177982_a(xwidth, 0, zwidth));
        int random = ModWorld.randInt(0, 10);
        return posAboveGround.func_177956_o() > 63 && corner1 && corner2 && random == 5;
    }

    public static boolean isCornerValid(World world, BlockPos pos) {
        int variation = 3;
        int highestBlock = ModWorld.getGroundFromAbove(world, pos.func_177958_n(), pos.func_177952_p());
        return highestBlock > pos.func_177956_o() - variation && highestBlock < pos.func_177956_o() + variation;
    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }
}

