/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.tiles;

import be.nevoka.core.content.tiles.TileEntityNevokaFurnace;
import be.nevoka.core.helpers.game.FurnaceHelper;
import be.nevoka.core.helpers.game.NevokaItemStackHelper;
import be.nevoka.morerefinedstorage.blocks.BlockFusionFurnace;
import be.nevoka.morerefinedstorage.fusion.FusionFurnaceRecipes;
import be.nevoka.morerefinedstorage.inventory.ContainerFusionFurnace;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityFusionFurnace
extends TileEntityNevokaFurnace {
    public static final int NDX_INPUT1_SLOT = 0;
    public static final int NDX_INPUT2_SLOT = 1;
    public static final int NDX_CATALYST_SLOT = 2;
    public static final int NDX_FUEL_SLOT = 3;
    public static final int NDX_OUTPUT_SLOT = 4;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    public static final String tilename = "container.fusion_furnace";
    public static final String guiID = "morerefinedstorage:fusion_furnace_gui";
    protected static int[] slotsTop = new int[]{2};
    protected static int[] slotsLeft = new int[]{0};
    protected static int[] slotsRight = new int[]{1};
    protected static int[] slotsInput = new int[]{0, 1, 2, 3};
    protected static int[] slotsBottom = new int[]{4, 3};
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntityFusionFurnace() {
        super(tilename, 600, guiID, 5);
    }

    public static void registerFixesFurnace(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityFusionFurnace.class, new String[]{"Items"}));
    }

    public int getCurrentCooktime() {
        return this.cookTime;
    }

    public static int getItemBurnTime(ItemStack burnItem) {
        double burnTimeModifier = 1.875;
        return (int)((double)TileEntityNevokaFurnace.getItemBurnTime((ItemStack)burnItem) * burnTimeModifier);
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = this.func_70301_a(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        FurnaceHelper.SetInSlot(this.furnaceItemStacks, (int)index, (ItemStack)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (!(index != 0 && index != 1 && index != 2 || flag)) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFusionFurnace(playerInventory, this);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 4) {
            return false;
        }
        ItemStack itemstack = this.func_70301_a(3);
        boolean isFuel = this.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar;
        boolean isCatalyst = FusionFurnaceRecipes.isItemCatalyst(stack);
        boolean isItem = FusionFurnaceRecipes.isItemInput(stack);
        boolean isItem2 = FusionFurnaceRecipes.isItemInput2(stack);
        if (isItem && index == 0 || isItem2 && index == 1) {
            return true;
        }
        if (isCatalyst && index == 2) {
            return true;
        }
        return isFuel && index == 3;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return slotsBottom;
        }
        return slotsInput;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 3 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public void func_73660_a() {
        boolean was_burning_flag = this.isBurning();
        boolean flag1 = false;
        int burnTime = 0;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelstack = this.func_70301_a(3);
            if (!fuelstack.func_190926_b()) {
                burnTime = TileEntityFusionFurnace.getItemBurnTime(fuelstack);
            }
            flag1 = this.default_cooking_update(flag1, fuelstack, burnTime);
            if (was_burning_flag != this.isBurning()) {
                flag1 = true;
                this.setState(true);
                BlockFusionFurnace.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void setState(boolean state) {
        if (this.isBurning() != state) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, blockState, blockState, 3);
            this.func_145831_w().func_180501_a(this.field_174879_c, blockState, 3);
        }
    }

    public boolean getState() {
        return this.isBurning();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean stateIndex = packet.func_148857_g().func_74767_n("state");
        if (this.field_145850_b.field_72995_K && stateIndex != this.isBurning()) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTag = super.func_189517_E_();
        nbtTag.func_74757_a("state", this.isBurning());
        return nbtTag;
    }

    protected boolean default_cooking_update(boolean flag1, ItemStack fuelStack, int burnTime) {
        ItemStack leftstack = this.func_70301_a(0);
        ItemStack rightstack = this.func_70301_a(1);
        ItemStack catastack = this.func_70301_a(2);
        if (this.isBurning() || !fuelStack.func_190926_b() && !leftstack.func_190926_b() && !rightstack.func_190926_b() && !catastack.func_190926_b()) {
            if (!this.isBurning() && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = burnTime;
                if (this.isBurning()) {
                    flag1 = true;
                    if (!fuelStack.func_190926_b()) {
                        Item item = fuelStack.func_77973_b();
                        fuelStack.func_190918_g(1);
                        if (fuelStack.func_190926_b()) {
                            ItemStack item1 = item.getContainerItem(fuelStack);
                            FurnaceHelper.SetInSlot(this.furnaceItemStacks, (int)3, (ItemStack)item1);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime == this.totalCookTime) {
                    this.cookTime = 0;
                    this.totalCookTime = this.getCookTime(this.func_70301_a(0));
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
        } else if (!this.isBurning() && this.cookTime > 0) {
            this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
        }
        return flag1;
    }

    protected boolean canSmelt() {
        if (this.func_70301_a(0).func_190926_b() || this.func_70301_a(1).func_190926_b() || this.func_70301_a(2).func_190926_b()) {
            return false;
        }
        ItemStack result_stack = FusionFurnaceRecipes.getSmeltingResult(this.func_70301_a(0), this.func_70301_a(1), this.func_70301_a(2));
        if (result_stack.func_190926_b()) {
            return false;
        }
        ItemStack outstack = this.func_70301_a(4);
        if (outstack.func_190926_b()) {
            return true;
        }
        if (!outstack.func_77969_a(result_stack)) {
            return false;
        }
        int result = outstack.func_190916_E() + result_stack.func_190916_E();
        return result <= this.func_70297_j_() && result <= outstack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FusionFurnaceRecipes.applyFusion(this.func_70301_a(0), this.func_70301_a(1), this.func_70301_a(2));
            ItemStack outstack = this.func_70301_a(4);
            if (outstack.func_190926_b()) {
                FurnaceHelper.SetInSlot(this.furnaceItemStacks, (int)4, (ItemStack)itemstack.func_77946_l());
            } else if (outstack.func_77973_b() == itemstack.func_77973_b()) {
                outstack.func_190917_f(itemstack.func_190916_E());
            }
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFusionFurnace.getItemBurnTime(this.func_70301_a(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        NevokaItemStackHelper.write_itemStackToNBT((NBTTagCompound)compound, this.furnaceItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }
}

