/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.proxy;

import be.nevoka.core.core.NevokaCoreAPI;
import be.nevoka.core.logger.LogHelper;
import be.nevoka.core.registry.ContentRegistry;
import be.nevoka.core.registry.Plugin;
import be.nevoka.morerefinedstorage.Content;
import be.nevoka.morerefinedstorage.MoreRefinedStorage;
import be.nevoka.morerefinedstorage.Settings;
import be.nevoka.morerefinedstorage.blocks.ModBlocks;
import be.nevoka.morerefinedstorage.entities.ModEntities;
import be.nevoka.morerefinedstorage.items.ModItems;
import be.nevoka.morerefinedstorage.modsupport.tconstruct.tconstructCompat;
import be.nevoka.morerefinedstorage.potions.ModPotions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class ProxyCommon {
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ContentRegistry.registerPlugin((Plugin)MoreRefinedStorage.plugin);
        Settings.createOrLoadSettings(event);
        NevokaCoreAPI.tabPreInit();
        ModEntities.preInit();
        Content.preInitialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModEntities.init();
        ProxyCommon.setTabIcons();
        Content.setRepairMaterials();
        if (Loader.isModLoaded((String)"tconstruct")) {
            tconstructCompat.initTraits();
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Content.addFusionRecipes();
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        LogHelper.info((String)"morerefinedstorage", (String)"Register Potions!");
        ModPotions.registerPotions();
    }

    private static void setTabIcons() {
        LogHelper.verbose((String)"morerefinedstorage", (String)"Setting tab icons");
        ArrayList list = Lists.newArrayList((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150366_p), Item.func_150898_a((Block)ModBlocks.crystalized_block), ModItems.crystalized_ingot, ModItems.crystalized_pickaxe, ModItems.crystalized_sword, Item.func_150898_a((Block)Blocks.field_150460_al)});
        NevokaCoreAPI.setTabIcons((List)list);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.register();
        ModBlocks.registerItemBlocks();
        OreDictionary.registerOre((String)"blockCrystalized", (ItemStack)new ItemStack((Block)ModBlocks.crystalized_block));
        OreDictionary.registerOre((String)"ingotCrystalized", (ItemStack)new ItemStack((Item)ModItems.crystalized_ingot));
    }

    public void registerItemRenderer(Plugin plugin, Item item, int meta, String id) {
    }
}

