/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.modsupport.crafttweaker;

import be.nevoka.morerefinedstorage.fusion.FusionFurnaceRecipes;
import be.nevoka.morerefinedstorage.fusion.FusionMaterial;
import be.nevoka.morerefinedstorage.fusion.RecipeEntry;
import be.nevoka.morerefinedstorage.modsupport.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.morerefinedstorage.FusionFurnace")
public class FusionFurnaceCT {
    private static RecipeEntry createRecipe(IItemStack output, IIngredient input1, IIngredient input2, IIngredient catalyst) {
        FusionMaterial Input1 = FusionMaterial.of(CraftTweakerHelper.toStack(input1));
        FusionMaterial Input2 = FusionMaterial.of(CraftTweakerHelper.toStack(input2));
        FusionMaterial Catalyst = FusionMaterial.of(CraftTweakerHelper.toStack(catalyst));
        ItemStack Output = CraftTweakerHelper.toStack(output);
        RecipeEntry r = new RecipeEntry(Input1, Input2, Catalyst, Output);
        return r;
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input1, IIngredient input2, IIngredient catalyst) {
        RecipeEntry r = FusionFurnaceCT.createRecipe(output, input1, input2, catalyst);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input1, IIngredient input2, IIngredient catalyst, float experience) {
        RecipeEntry r = FusionFurnaceCT.createRecipe(output, input1, input2, catalyst);
        CraftTweakerAPI.apply((IAction)new Add(r, Float.valueOf(experience)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<RecipeEntry> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = FusionFurnaceRecipes.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing FusionFurnace Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final RecipeEntry recipe;
        private float experience = 1.0f;

        public Add(RecipeEntry recipe, Float experience) {
            this.recipe = recipe;
            this.experience = experience.floatValue();
        }

        public Add(RecipeEntry recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            FusionFurnaceRecipes.getRecipeList().add(this.recipe);
            FusionFurnaceRecipes.setExperience(this.recipe.getOutput().func_77946_l(), this.experience);
        }

        public String describe() {
            return "Adding FusionFurnace Recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

