/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.items.drives;

import be.nevoka.morerefinedstorage.items.ItemBase;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSyncData;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class RefinedStorageCellBase
extends ItemBase
implements IStorageDiskProvider {
    private static final String NBT_ID = "id";

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K) {
            if (!this.isValid(stack)) {
                API.instance().getOneSixMigrationHelper().migrateDisk(world, stack);
            }
            if (!stack.func_77942_o()) {
                UUID id = UUID.randomUUID();
                API.instance().getStorageDiskManager(world).set(id, this.createDefaultDisk(world, this.getCapacity(stack)));
                API.instance().getStorageDiskManager(world).markForSaving();
                this.setId(stack, id);
            }
        }
    }

    public abstract IStorageDisk createDefaultDisk(World var1, int var2);

    public void func_77624_a(ItemStack disk, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.isValid(disk)) {
            UUID id = this.getId(disk);
            API.instance().getStorageDiskSync().sendRequest(id);
            IStorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}));
                } else {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}));
                }
            }
            if (flag.func_194127_a()) {
                tooltip.add(id.toString());
            }
        }
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a(NBT_ID);
    }

    public void setId(ItemStack disk, UUID id) {
        disk.func_77982_d(new NBTTagCompound());
        disk.func_77978_p().func_186854_a(NBT_ID, id);
    }

    public boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b(NBT_ID);
    }
}

