/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.fusion;

import be.nevoka.morerefinedstorage.fusion.FusionMaterial;
import net.minecraft.item.ItemStack;

public class RecipeEntry {
    public final FusionMaterial input1;
    public final FusionMaterial input2;
    public final FusionMaterial catalyst;
    private final ItemStack output;

    public RecipeEntry(FusionMaterial input1, FusionMaterial input2, FusionMaterial catalyst, ItemStack output) {
        this.input1 = input1;
        this.input2 = input2;
        this.catalyst = catalyst;
        this.output = output.func_77946_l();
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public FusionMaterial getInput1() {
        return this.input1;
    }

    public FusionMaterial getInput2() {
        return this.input2;
    }

    public FusionMaterial getCatalyst() {
        return this.catalyst;
    }

    public boolean matches(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        return this.catalyst.matches(catalyst) && (this.input1.matches(input1) && this.input2.matches(input2) || this.input1.matches(input2) && this.input2.matches(input1));
    }

    public ItemStack applyFusion(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        if (this.input1.matches(input1) && this.input2.matches(input2)) {
            this.input1.decrStackSize(input1);
            this.input2.decrStackSize(input2);
        } else {
            this.input1.decrStackSize(input2);
            this.input2.decrStackSize(input1);
        }
        this.catalyst.decrStackSize(catalyst);
        return this.output.func_77946_l();
    }

    public boolean isItemInput(ItemStack item) {
        return this.input1.matches(item);
    }

    public boolean isItemInput2(ItemStack item) {
        return this.input2.matches(item);
    }

    public boolean isItemCatalyst(ItemStack item) {
        return this.catalyst.matches(item);
    }
}

