/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.fusion;

import be.nevoka.core.logger.LogHelper;
import be.nevoka.morerefinedstorage.fusion.FusionFurnaceRecipes;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public abstract class FusionMaterial {
    public static FusionMaterial of() {
        return new NullMaterial();
    }

    public static FusionMaterial of(String ore, int amount) {
        if (OreDictionary.doesOreNameExist((String)ore)) {
            return new DictMaterial(ore, amount);
        }
        ResourceLocation ore_name = new ResourceLocation(ore);
        if (Block.field_149771_c.func_82594_a((Object)ore_name) != Blocks.field_150350_a) {
            Block B = (Block)Block.field_149771_c.func_82594_a((Object)ore_name);
            return FusionMaterial.of(B, amount);
        }
        if (Item.field_150901_e.func_82594_a((Object)ore_name) != null) {
            Item I = (Item)Item.field_150901_e.func_82594_a((Object)ore_name);
            return FusionMaterial.of(I, amount);
        }
        LogHelper.severe((String)"morerefinedstorage", (String)("Material " + ore + " does not exist! Cannot create recipe."));
        return new NullMaterial();
    }

    public static FusionMaterial of(ItemStack stack) {
        return new StackMaterial(stack);
    }

    public static FusionMaterial of(String ore) {
        return FusionMaterial.of(ore, 1);
    }

    public static FusionMaterial of(Item item, int amount, int meta) {
        return FusionMaterial.of(new ItemStack(item, amount, meta));
    }

    public static FusionMaterial of(Item item, int amount) {
        return FusionMaterial.of(new ItemStack(item, amount, 0));
    }

    public static FusionMaterial of(Item item) {
        return FusionMaterial.of(new ItemStack(item, 1, 0));
    }

    public static FusionMaterial of(Block block, int amount, int meta) {
        return FusionMaterial.of(new ItemStack(block, amount, meta));
    }

    public static FusionMaterial of(Block block, int amount) {
        return FusionMaterial.of(new ItemStack(block, amount, 0));
    }

    public static FusionMaterial of(Block block) {
        return FusionMaterial.of(new ItemStack(block, 1, 0));
    }

    public abstract boolean matches(ItemStack var1);

    public abstract void decrStackSize(ItemStack var1);

    public abstract List<ItemStack> itemsList();

    public abstract int getAmount();

    public abstract int getMeta();

    public abstract String getOre();

    public abstract Item getItem();

    public static class StackMaterial
    extends FusionMaterial {
        private final ItemStack stack;

        StackMaterial(ItemStack stack) {
            if (stack.func_190926_b()) {
                throw new IllegalArgumentException(stack.toString());
            }
            this.stack = stack.func_77946_l();
        }

        @Override
        public boolean matches(ItemStack item) {
            if (item.func_190926_b() || item.func_190916_E() < this.stack.func_190916_E()) {
                return false;
            }
            return FusionFurnaceRecipes.matches(this.stack, item);
        }

        @Override
        public void decrStackSize(ItemStack item) {
            item.func_190918_g(this.stack.func_190916_E());
        }

        @Override
        public List<ItemStack> itemsList() {
            return Lists.newArrayList((Object[])new ItemStack[]{this.stack.func_77946_l()});
        }

        @Override
        public int getAmount() {
            return this.stack.func_190916_E();
        }

        @Override
        public Item getItem() {
            return this.stack.func_77973_b();
        }

        @Override
        public int getMeta() {
            return this.stack.func_77952_i();
        }

        @Override
        public String getOre() {
            return null;
        }
    }

    public static class DictMaterial
    extends FusionMaterial {
        public final String ore;
        public final int amount;

        DictMaterial(String ore, int amount) {
            if (amount < 0) {
                throw new IllegalArgumentException(Integer.valueOf(amount).toString());
            }
            this.ore = ore;
            this.amount = amount;
        }

        @Override
        public boolean matches(ItemStack item) {
            if (item.func_190926_b() || item.func_190916_E() < this.amount) {
                return false;
            }
            for (ItemStack stack : OreDictionary.getOres((String)this.ore, (boolean)false)) {
                if (!FusionFurnaceRecipes.matches(stack, item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void decrStackSize(ItemStack item) {
            item.func_190918_g(this.amount);
        }

        @Override
        public List<ItemStack> itemsList() {
            return OreDictionary.getOres((String)this.ore);
        }

        @Override
        public int getAmount() {
            return this.amount;
        }

        @Override
        public String getOre() {
            return this.ore;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public Item getItem() {
            return null;
        }
    }

    public static class NullMaterial
    extends FusionMaterial {
        NullMaterial() {
        }

        @Override
        public boolean matches(ItemStack item) {
            return item.func_190926_b();
        }

        @Override
        public void decrStackSize(ItemStack item) {
        }

        @Override
        public List<ItemStack> itemsList() {
            return Lists.newArrayList();
        }

        @Override
        public int getAmount() {
            return 0;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public String getOre() {
            return null;
        }

        @Override
        public Item getItem() {
            return null;
        }
    }
}

