/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.fusion;

import be.nevoka.morerefinedstorage.fusion.FusionMaterial;
import be.nevoka.morerefinedstorage.fusion.RecipeEntry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class FusionFurnaceRecipes {
    private static final ArrayList<RecipeEntry> recipeList = Lists.newArrayList();
    private static final HashMap<ItemStack, Float> experienceMap = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void addSmelting(FusionMaterial input1, FusionMaterial input2, FusionMaterial catalyst, ItemStack output, float experience) {
        recipeList.add(new RecipeEntry(input1, input2, catalyst, output));
        FusionFurnaceRecipes.setExperience(output.func_77946_l(), experience);
    }

    public static void addSmelting(ItemStack input1, ItemStack input2, ItemStack catalyst, ItemStack output, float experience) {
        FusionFurnaceRecipes.addSmelting(FusionMaterial.of(input1), FusionMaterial.of(input2), FusionMaterial.of(catalyst), output, experience);
    }

    public static RecipeEntry addRecipes(ItemStack output, ItemStack input1, ItemStack input2, ItemStack catalyst, float experience) {
        RecipeEntry r = new RecipeEntry(FusionMaterial.of(input1), FusionMaterial.of(input2), FusionMaterial.of(catalyst), output);
        FusionFurnaceRecipes.addSmelting(FusionMaterial.of(input1), FusionMaterial.of(input2), FusionMaterial.of(catalyst), output, experience);
        return r;
    }

    public static List<RecipeEntry> removeRecipes(ItemStack stack) {
        ArrayList<RecipeEntry> list = new ArrayList<RecipeEntry>();
        Iterator<RecipeEntry> it = recipeList.iterator();
        while (it.hasNext()) {
            RecipeEntry ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.getOutput(), (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static RecipeEntry findRecipe(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        for (RecipeEntry recipe : recipeList) {
            if ((!recipe.input1.matches(input1) || !recipe.input2.matches(input2) || !recipe.catalyst.matches(catalyst)) && (!recipe.input1.matches(input2) || !recipe.input2.matches(input1) || !recipe.catalyst.matches(catalyst))) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack getSmeltingResult(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        for (RecipeEntry e : recipeList) {
            if (!e.matches(input1, input2, catalyst)) continue;
            return e.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    public static void setExperience(ItemStack output, float experience) {
        if (!experienceMap.containsKey(output)) {
            experienceMap.put(output.func_77946_l(), Float.valueOf(experience));
        }
    }

    public static ItemStack applyFusion(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        for (RecipeEntry e : recipeList) {
            if (!e.matches(input1, input2, catalyst)) continue;
            return e.applyFusion(input1, input2, catalyst);
        }
        return ItemStack.field_190927_a;
    }

    public static float getExperience(ItemStack item) {
        Float exp = experienceMap.get(item);
        return exp == null ? 0.0f : exp.floatValue();
    }

    public static boolean isItemCatalyst(ItemStack item) {
        for (RecipeEntry e : recipeList) {
            if (!e.isItemCatalyst(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemInput(ItemStack item) {
        for (RecipeEntry e : recipeList) {
            if (!e.isItemInput(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemInput2(ItemStack item) {
        for (RecipeEntry e : recipeList) {
            if (!e.isItemInput2(item)) continue;
            return true;
        }
        return false;
    }

    public static List<RecipeEntry> getRecipeList() {
        return recipeList;
    }

    public static Map<ItemStack, Float> getExperienceList() {
        return experienceMap;
    }

    public static boolean matches(ItemStack target, ItemStack stack) {
        if (ItemStack.func_179545_c((ItemStack)target, (ItemStack)stack)) {
            return true;
        }
        return target.func_77960_j() == Short.MAX_VALUE && ItemStack.func_185132_d((ItemStack)target, (ItemStack)stack);
    }
}

