/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage.entities;

import be.nevoka.morerefinedstorage.MoreRefinedStorage;
import be.nevoka.morerefinedstorage.entities.hostile.EntityGlaceSkeleton;
import be.nevoka.morerefinedstorage.entities.hostile.RenderGlaceSkeleton;
import be.nevoka.morerefinedstorage.entities.layer.LayerFreezingRenderer;
import be.nevoka.morerefinedstorage.entities.projectiles.frost_shot.EntityFrostShot;
import be.nevoka.morerefinedstorage.entities.projectiles.frost_shot.RenderFrostShot;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeVoid;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ModEntities {
    private static int EntityID = 0;

    public static void preInit() {
        ModEntities.register(EntityID++, "glaceskeleton", EntityGlaceSkeleton.class, "glaceskeleton", 64, 1, true);
        ModEntities.register(EntityID++, "frost_shot", EntityFrostShot.class, "frost_shot", 64, 1, true);
        ModEntities.addSpawnInfo("glaceskeleton", 0xBFF4FF, 54527);
    }

    public static void init() {
        Biome[] spawnBiomes = ModEntities.getAllSpawnBiomes(false, false);
        EntityRegistry.addSpawn(EntityGlaceSkeleton.class, (int)10, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    public static void registerModels() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGlaceSkeleton.class, RenderGlaceSkeleton::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFrostShot.class, RenderFrostShot::new);
        MinecraftForge.EVENT_BUS.register((Object)LayerFreezingRenderer.INSTANCE);
    }

    private static void register(int id, String name, Class<? extends Entity> clazz, String oldName, int TrackingRange, int UpdateFrequency, boolean velocityUpdates) {
        ResourceLocation resourcelocation = new ResourceLocation("morerefinedstorage", name);
        EntityRegistry.registerModEntity((ResourceLocation)resourcelocation, clazz, (String)oldName, (int)id, (Object)MoreRefinedStorage.instance, (int)TrackingRange, (int)UpdateFrequency, (boolean)velocityUpdates);
    }

    protected static EntityList.EntityEggInfo addSpawnInfo(String id, int primaryColor, int secondaryColor) {
        ResourceLocation resourcelocation = new ResourceLocation("morerefinedstorage", id);
        EntityList.EntityEggInfo egg = new EntityList.EntityEggInfo(resourcelocation, primaryColor, secondaryColor);
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(resourcelocation);
        if (entry != null) {
            entry.setEgg(egg);
        }
        return EntityList.field_75627_a.put(resourcelocation, egg);
    }

    private static Biome[] getAllSpawnBiomes(boolean spawnInNether, boolean spawnInEnd) {
        LinkedList<Biome> list = new LinkedList<Biome>();
        Collection biomes = ForgeRegistries.BIOMES.getValuesCollection();
        for (Biome bgb : biomes) {
            if (bgb instanceof BiomeVoid || bgb instanceof BiomeEnd && !spawnInEnd || bgb instanceof BiomeHell && !spawnInNether || list.contains(bgb)) continue;
            list.add(bgb);
        }
        return list.toArray(new Biome[0]);
    }

    private static Biome[] getBiomesFromTypes(BiomeDictionary.Type ... types) {
        LinkedList<Biome> list = new LinkedList<Biome>();
        Collection biomes = ForgeRegistries.BIOMES.getValuesCollection();
        for (Biome biome : biomes) {
            int count = types.length;
            int shouldAdd = 0;
            for (BiomeDictionary.Type t : types) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)) continue;
                ++shouldAdd;
            }
            if (list.contains(biome) || shouldAdd != count) continue;
            list.add(biome);
        }
        return list.toArray(new Biome[0]);
    }

    private static Biome[] excludeBiomesWithTypes(BiomeDictionary.Type ... types) {
        LinkedList<Biome> list = new LinkedList<Biome>();
        Collection biomes = ForgeRegistries.BIOMES.getValuesCollection();
        for (Biome biome : biomes) {
            for (BiomeDictionary.Type t : types) {
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t) || list.contains(biome)) continue;
                list.add(biome);
            }
        }
        return list.toArray(new Biome[0]);
    }
}

