/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage;

import be.nevoka.core.config.ConfigHelper;
import be.nevoka.core.config.types.ConfigArmor;
import be.nevoka.core.config.types.ConfigBlock;
import be.nevoka.core.config.types.ConfigItem;
import be.nevoka.core.config.types.ConfigTool;
import be.nevoka.core.logger.LogHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Settings {
    private static Configuration settings;
    public static ConfigBlock crystalizedBlock;
    public static ConfigBlock fusionFurnace;
    public static ConfigItem crystalizedIngot;
    public static ConfigItem crystalizedNugget;
    public static ConfigItem crystalizedDust;
    public static ConfigTool crystalizedTool;
    public static ConfigArmor crystalizedArmor;

    public static void createOrLoadSettings(FMLPreInitializationEvent event) {
        settings = ConfigHelper.GetConfig((FMLPreInitializationEvent)event, (String)"Nevoka", (String)"morerefinedstorage.cfg");
        LogHelper.verbose((String)"morerefinedstorage", (String)"loading settings...");
        try {
            settings.load();
            ConfigHelper.createHelpEntry((Configuration)settings, (String)"https://minecraft.curseforge.com/projects/morerefinedstorage");
            Settings.configureBlocks();
            Settings.configureItems();
            Settings.configureOres();
            Settings.configureTools();
            Settings.configureArmor();
        }
        catch (Exception e) {
            LogHelper.severe((String)"morerefinedstorage", (String)"Failed to load settings");
            e.printStackTrace();
        }
        finally {
            if (settings.hasChanged()) {
                settings.save();
            }
            LogHelper.verbose((String)"morerefinedstorage", (String)"Settings loaded successfully");
        }
    }

    public static void configureItems() {
        crystalizedDust = new ConfigItem("Crystalized Dust", "Items");
        crystalizedDust.GetConfig(settings);
        crystalizedIngot = new ConfigItem("Crystalized Ingot", "Items");
        crystalizedIngot.GetConfig(settings);
        crystalizedNugget = new ConfigItem("Crystalized Nugget", "Items");
        crystalizedNugget.GetConfig(settings);
    }

    public static void configureTools() {
        crystalizedTool = new ConfigTool("Crystalized Tools").setUses(2500).setHarvestLevel(4).setHarvestSpeed(9.0f).setDamageVsEntity(5.0f).setEnchantability(25);
        crystalizedTool.GetConfig(settings);
    }

    public static void configureArmor() {
        crystalizedArmor = new ConfigArmor("Crystalized Armor").setDurability(3500).setEnchantability(25).setHelmReduction(3).setChestReduction(8).setLegsReduction(6).setBootsReduction(3);
        crystalizedArmor.GetConfig(settings);
    }

    public static void configureBlocks() {
        crystalizedBlock = new ConfigBlock("Crystalized  Block", "Blocks").setHardness(14.0f).setLightValue(0.2f).setResistance(15.0f).setHarvestLevel(2).setHarvestTool("pickaxe").setBeaconBase(true);
        crystalizedBlock.GetConfig(settings);
        fusionFurnace = new ConfigBlock("Fusion Furnace", "Machines").setHardness(3.5f).setResistance(10.0f).setLightValue(1.0f).setHarvestTool("pickaxe");
        fusionFurnace.GetConfig(settings);
    }

    public static void configureOres() {
    }
}

