/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.morerefinedstorage;

import be.nevoka.core.logger.LogHelper;
import be.nevoka.core.registry.Plugin;
import be.nevoka.morerefinedstorage.entities.ModClientEvents;
import be.nevoka.morerefinedstorage.fusion.FusionFurnaceRecipes;
import be.nevoka.morerefinedstorage.helpers.FusionGuiHandler;
import be.nevoka.morerefinedstorage.modsupport.RegisterCompat;
import be.nevoka.morerefinedstorage.network.UpdateFreezeEffect;
import be.nevoka.morerefinedstorage.proxy.ProxyCommon;
import be.nevoka.morerefinedstorage.utils.WorldLoot;
import be.nevoka.morerefinedstorage.world.ModWorld;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="morerefinedstorage", name="More Refined Storage", version="1.1.6", dependencies="required-after:refinedstorage;required-after:reborncore;required-after:nevokacore;after:tconstruct;after:guideapi;", acceptedMinecraftVersions="[1.12,)", updateJSON="http://morerefinedstorage.nevoka.be/update", certificateFingerprint="d68758e79dc66e96a127d04bc039f1ec860a1537")
public class MoreRefinedStorage {
    @Mod.Instance(value="morerefinedstorage")
    public static MoreRefinedStorage instance;
    public static final DamageSource FROSTBITE;
    public static SimpleNetworkWrapper packetHandle;
    @SidedProxy(clientSide="be.nevoka.morerefinedstorage.proxy.ProxyClient", serverSide="be.nevoka.morerefinedstorage.proxy.ProxyCommon")
    public static ProxyCommon proxy;
    public static Plugin plugin;

    public MoreRefinedStorage() {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LogHelper.warning((String)"morerefinedstorage", (String)("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!"));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.info((String)"morerefinedstorage", (String)"Loading...");
        proxy.preInit(event);
        if (event.getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new ModClientEvents());
        }
        RegisterCompat.registerCompat(event);
        WorldLoot.initLootTables();
        packetHandle = NetworkRegistry.INSTANCE.newSimpleChannel("morerefinedstorage");
        packetHandle.registerMessage(UpdateFreezeEffect.Handler.class, UpdateFreezeEffect.class, 1, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new FusionGuiHandler());
        proxy.init(event);
        ModWorld.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RegisterCompat.compatjer();
        proxy.postInit(event);
        LogHelper.verbose((String)"morerefinedstorage", (String)(FusionFurnaceRecipes.getRecipeList().size() + " Infusion Furnace recipes were loaded"));
        LogHelper.info((String)"morerefinedstorage", (String)"Loading Complete!");
    }

    static {
        FROSTBITE = new DamageSource("morerefinedstorage.frostbite");
        plugin = new Plugin("morerefinedstorage", "More Refined Storage");
    }
}

