/*
 * Decompiled with CFR 0.152.
 */
package redstoneparadox.tinkersarsenal.tools.ranged;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import redstoneparadox.tinkersarsenal.TASounds;
import redstoneparadox.tinkersarsenal.tools.TATools;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.client.BooleanItemPropertyGetter;
import slimeknights.tconstruct.library.client.crosshair.Crosshairs;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.client.crosshair.ICustomCrosshairUser;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class ToolBoomstick
extends BowCore
implements ICustomCrosshairUser {
    private static final String TAG_Loaded = "Loaded";
    protected static final ResourceLocation PROPERTY_IS_LOADED = new ResourceLocation("loaded");
    private ImmutableList<Item> boltMatches = null;

    public ToolBoomstick() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TATools.boomstickHandle), PartMaterialType.bow((IToolPart)TATools.boomstickBarrel), PartMaterialType.head((IToolPart)TATools.bayonet)});
        ((Item)this.setRegistryName("boomstick")).func_77655_b("boomstick");
        this.func_185043_a(PROPERTY_PULL_PROGRESS, this.pullProgressPropertyGetter);
        this.func_185043_a(PROPERTY_IS_PULLING, this.isPullingPropertyGetter);
        this.func_185043_a(PROPERTY_IS_LOADED, (IItemPropertyGetter)new BooleanItemPropertyGetter(){

            public boolean applyIf(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && ToolBoomstick.this.isLoaded(stack);
            }
        });
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_77640_w() == tab) {
            this.addDefaultSubItems((List)subItems, new Material[]{null, null, null, TinkerMaterials.string});
        }
    }

    public float damagePotential() {
        return 0.8f;
    }

    public double attackSpeed() {
        return 2.0;
    }

    public float baseProjectileDamage() {
        return 4.0f;
    }

    protected float baseProjectileSpeed() {
        return 9.0f;
    }

    public float projectileDamageModifier() {
        return 1.3f;
    }

    public int getDrawTime() {
        return 45;
    }

    public boolean isLoaded(ItemStack stack) {
        return TagUtil.getTagSafe((ItemStack)stack).func_74767_n(TAG_Loaded);
    }

    public void setLoaded(ItemStack stack, boolean isLoaded) {
        NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)stack);
        tag.func_74757_a(TAG_Loaded, isLoaded);
        stack.func_77982_d(tag);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.195f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!this.isLoaded(itemStackIn) || ToolHelper.isBroken((ItemStack)itemStackIn)) {
            return super.func_77659_a(worldIn, playerIn, hand);
        }
        super.func_77615_a(itemStackIn, worldIn, (EntityLivingBase)playerIn, 0);
        this.setLoaded(itemStackIn, false);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!ToolHelper.isBroken((ItemStack)stack) && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int useTime = this.func_77626_a(stack) - timeLeft;
            if (this.getDrawbackProgress(stack, useTime) >= 1.0f) {
                if (player.field_71075_bZ.field_75098_d) {
                    Sounds.PlaySoundForPlayer((Entity)entityLiving, (SoundEvent)Sounds.crossbow_reload, (float)1.5f, (float)(0.9f + field_77697_d.nextFloat() * 0.1f));
                    this.setLoaded(stack, true);
                } else {
                    ItemStack itemStack = this.findGunpowder(player);
                    if (itemStack != null) {
                        itemStack.func_190918_g(1);
                        if (itemStack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(itemStack);
                        }
                        Sounds.PlaySoundForPlayer((Entity)entityLiving, (SoundEvent)Sounds.crossbow_reload, (float)1.5f, (float)(0.9f + field_77697_d.nextFloat() * 0.1f));
                        this.setLoaded(stack, true);
                    }
                }
            }
        }
    }

    public ItemStack findGunpowder(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (itemStack.func_77973_b() != Items.field_151016_H) continue;
            return itemStack;
        }
        return null;
    }

    public void playShootSound(float power, World world, EntityPlayer entityPlayer) {
        world.func_184148_a(null, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, TASounds.BOOMSTICK_SHOT, SoundCategory.NEUTRAL, 1.0f, 0.5f + field_77697_d.nextFloat() * 0.1f);
    }

    public ItemStack getAmmoToRender(ItemStack weapon, EntityLivingBase player) {
        if (!this.isLoaded(weapon)) {
            return ItemStack.field_190927_a;
        }
        return super.getAmmoToRender(weapon, player);
    }

    protected List<Item> getAmmoItems() {
        if (this.boltMatches == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (TATools.boomstickShot != null) {
                builder.add((Object)TATools.boomstickShot);
            }
            this.boltMatches = builder.build();
        }
        return this.boltMatches;
    }

    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        BowMaterialStats barrel = (BowMaterialStats)materials.get(0).getStatsOrUnknown("bow");
        HeadMaterialStats bayonet = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        data.handle(new HandleMaterialStats[]{handle});
        data.limb(new BowMaterialStats[]{barrel});
        data.head(new HeadMaterialStats[]{bayonet});
        data.bonusDamage *= 1.5f;
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public ICrosshair getCrosshair(ItemStack itemStack, EntityPlayer player) {
        return Crosshairs.T;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCrosshairState(ItemStack itemStack, EntityPlayer player) {
        if (this.isLoaded(itemStack)) {
            return 1.0f;
        }
        if (player.func_184607_cu() != itemStack) {
            return 0.0f;
        }
        return this.getDrawbackProgress(itemStack, (EntityLivingBase)player);
    }
}

