/*
 * Decompiled with CFR 0.152.
 */
package redstoneparadox.tinkersarsenal.materials.tooltraits;

import com.google.common.collect.ImmutableSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;

public class TraitMalleable
extends AbstractTrait {
    public TraitMalleable() {
        super("malleable", 14448147);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        NBTTagCompound webbedTag;
        this.dealFireDamage(tool, player, target);
        NBTTagCompound shulkingTag = TinkerUtil.getModifierTag((ItemStack)tool, (String)"shulking");
        if (shulkingTag != null) {
            int shulkingAmount = ModifierNBT.readInteger((NBTTagCompound)shulkingTag).current;
            int shulkingDuration = shulkingAmount / 2 + 10 + Math.round((long)((double)(shulkingAmount / 2 + 10) * 0.1));
            target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, shulkingDuration, 0));
        }
        if ((webbedTag = TinkerUtil.getModifierTag((ItemStack)tool, (String)"webbed")) != null) {
            int webbedLevel = ModifierNBT.readInteger((NBTTagCompound)webbedTag).level;
            int webbedDuration = webbedLevel * 20 + webbedLevel * 2;
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, webbedDuration, 1));
        }
    }

    protected void dealFireDamage(ItemStack tool, EntityLivingBase attacker, EntityLivingBase target) {
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)tool, (String)"fiery");
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger((NBTTagCompound)tag);
        int duration = this.getFireDuration(data);
        target.func_70015_d(duration);
        float fireDamage = this.getFireDamage(data) / 2.0f;
        if (TraitMalleable.attackEntitySecondary((DamageSource)new EntityDamageSource("onFire", (Entity)attacker).func_76361_j(), (float)fireDamage, (Entity)target, (boolean)false, (boolean)true)) {
            int count = Math.round(fireDamage);
            TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_FIRE, (Entity)target, count);
        }
    }

    private float getFireDamage(ModifierNBT.IntegerNBT data) {
        return (float)data.current / 15.0f;
    }

    private int getFireDuration(ModifierNBT.IntegerNBT data) {
        return 1 + data.current / 8;
    }

    public float knockBack(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float knockback, float newKnockback, boolean isCritical) {
        return newKnockback + this.calcKnockback(TinkerUtil.getModifierTag((ItemStack)tool, (String)"knockback"));
    }

    protected float calcKnockback(NBTTagCompound modifierTag) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger((NBTTagCompound)modifierTag);
        return (float)data.current * 0.1f;
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        float amount;
        if (wasHit && (amount = damageDealt * this.lifesteal(TinkerUtil.getModifierTag((ItemStack)tool, (String)"necrotic"))) > 0.0f) {
            player.func_70691_i(amount);
        }
    }

    private float lifesteal(NBTTagCompound modifierNBT) {
        ModifierNBT data = new ModifierNBT(modifierNBT);
        return 0.05f * (float)data.level;
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        ModifierNBT.IntegerNBT hasteAmount = ModifierNBT.readInteger((NBTTagCompound)rootCompound.func_74775_l("haste"));
        ModifierNBT.IntegerNBT luckAmount = ModifierNBT.readInteger((NBTTagCompound)rootCompound.func_74775_l("luck"));
        ModifierNBT.IntegerNBT sharpAmount = ModifierNBT.readInteger((NBTTagCompound)rootCompound.func_74775_l("sharpness"));
        ModifierNBT.IntegerNBT beheadingAmount = ModifierNBT.readInteger((NBTTagCompound)rootCompound.func_74775_l("beheading"));
        ModifierNBT.IntegerNBT smiteAmount = ModifierNBT.readInteger((NBTTagCompound)rootCompound.func_74775_l("smite"));
        ModifierNBT.IntegerNBT baneAmount = ModifierNBT.readInteger((NBTTagCompound)rootCompound.func_74775_l("bane"));
        ImmutableSet categories = ImmutableSet.copyOf((Object[])TagUtil.getCategories((NBTTagCompound)rootCompound));
        boolean harvest = categories.contains(Category.HARVEST);
        boolean weapon = categories.contains(Category.WEAPON);
        boolean launcher = categories.contains(Category.LAUNCHER);
        if (harvest) {
            if (hasteAmount != null) {
                return;
            }
            if (luckAmount != null) {
                return;
            }
            if (sharpAmount != null) {
                return;
            }
            if (beheadingAmount != null) {
                return;
            }
            if (smiteAmount != null) {
                return;
            }
            if (baneAmount != null) {
                return;
            }
        } else if (weapon) {
            if (hasteAmount != null) {
                return;
            }
            if (luckAmount != null) {
                return;
            }
            if (sharpAmount != null) {
                return;
            }
            if (beheadingAmount != null) {
                return;
            }
            if (smiteAmount != null) {
                return;
            }
            if (baneAmount != null) {
                return;
            }
        } else if (launcher) {
            if (hasteAmount != null) {
                return;
            }
            if (luckAmount != null) {
                return;
            }
            if (sharpAmount != null) {
                return;
            }
            if (beheadingAmount != null) {
                return;
            }
            if (smiteAmount != null) {
                return;
            }
            if (baneAmount != null) {
                return;
            }
        }
    }

    public int getPriority() {
        return 49;
    }
}

