/*
 * Decompiled with CFR 0.152.
 */
package redstoneparadox.tinkersarsenal.materials;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import redstoneparadox.tinkersarsenal.TAConfig;
import redstoneparadox.tinkersarsenal.TinkersArsenal;
import redstoneparadox.tinkersarsenal.lib.misc.TAMaterial;
import redstoneparadox.tinkersarsenal.materials.tooltraits.TATraits;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;

public class TAMaterials {
    TAMaterial diamond = new TAMaterial("diamond", 3402699);

    public void initMaterials() {
        if (this.isRegisterable("diamond")) {
            this.diamond.setRegistered();
            this.setCraftability(this.diamond, "gemDiamond");
            this.diamond.setRepresentativeItem(new ItemStack(Items.field_151045_i));
            this.addTraits((Material)this.diamond, TATraits.diamondEdge, "head");
            this.addTraits((Material)this.diamond, TATraits.resilience, true);
            this.addStats(this.diamond, 1270, 6.0f, 5.0f, 3, 1.1f, 100, 269, 0.5f, 1.5f, 1.75f);
            TinkerRegistry.addMaterial((Material)this.diamond);
        }
    }

    public boolean isRegisterable(String id) {
        return TinkerRegistry.getMaterial((String)id).equals(Material.UNKNOWN) && TAConfig.materialIsAllowed(id);
    }

    public void setCraftability(Material material, String item, Fluid fluid) {
        String suffix = TAMaterials.removePrefix(item);
        material.addItemIngot(suffix);
        material.setCastable(true).setCraftable(false);
        material.setFluid(fluid);
        TinkerRegistry.integrate((Material)material, (Fluid)fluid, (String)suffix).toolforge();
    }

    public void setCraftability(Material material, String item) {
        String suffix = TAMaterials.removePrefix(item);
        String blockString = new String("block" + suffix);
        material.addItem(item, 1, 144);
        material.addItem(blockString, 1, 1296);
        material.setCraftable(true).setCastable(false);
        TinkerRegistry.integrate((Material)material, (String)suffix);
    }

    public void addTraits(Material material, AbstractTrait mainTrait, AbstractTrait secondTrait, String partType) {
        material.addTrait((ITrait)mainTrait, partType);
        material.addTrait((ITrait)secondTrait, partType);
    }

    public void addTraits(Material material, AbstractTrait trait, String partType) {
        material.addTrait((ITrait)trait, partType);
    }

    public void addTraits(Material material, AbstractTrait trait, boolean tools) {
        material.addTrait((ITrait)trait, "handle");
        material.addTrait((ITrait)trait, "extra");
    }

    public void addStats(Material material, int durabilityMain, float speed, float dmg, int harvest, float mod, int handleDurability, int extradurability, float drawspeed, float range, float bonusDamage) {
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(durabilityMain, speed, dmg, harvest), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(mod, handleDurability), new ExtraMaterialStats(extradurability), new BowMaterialStats(drawspeed, range, bonusDamage)});
    }

    public void addBowstringStats() {
    }

    public void addGuitarStats() {
    }

    @Deprecated
    public static String removePrefix(String item) {
        if (item.contains("gem")) {
            TinkersArsenal.logger.debug(item.substring(item.indexOf("gem") + 3));
            return item.substring(item.indexOf("gem") + 3);
        }
        if (item.contains("ingot")) {
            TinkersArsenal.logger.debug(item.substring(item.indexOf("ingot") + 5));
            return item.substring(item.indexOf("ingot") + 5);
        }
        TinkersArsenal.logger.debug("Prefix for the item does not match the prefixes in this method! This is what you get for making a whole method for the purpose of removing the prefix!");
        return null;
    }
}

