/*
 * Decompiled with CFR 0.152.
 */
package redstoneparadox.tinkersarsenal.materials;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import redstoneparadox.tinkersarsenal.lib.misc.TAMaterial;
import redstoneparadox.tinkersarsenal.materials.TAMaterials;
import redstoneparadox.tinkersarsenal.materials.armortraits.TAArmorTraits;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;

public class TAArmorMaterials {
    public void initArmorMaterials(TAMaterials materialsClass) {
        TAMaterial diamond = materialsClass.diamond;
        if (diamond.isRegistered()) {
            this.addTraits((Material)diamond, (AbstractTrait)TAArmorTraits.rigidity, ArmorMaterialType.CORE);
            this.addTraits((Material)diamond, (AbstractTrait)TAArmorTraits.resilience, false);
            this.addStats(diamond, 15.0f, 20.0f, 1.1f, 4.5f, 2.0f, 11.0f);
        }
    }

    public boolean isRegisterable(String id) {
        return TinkerRegistry.getMaterial((String)id).equals(Material.UNKNOWN);
    }

    public void addTraits(Material material, AbstractTrait mainTrait, AbstractTrait secondTrait, String partType) {
        material.addTrait((ITrait)mainTrait, partType);
        material.addTrait((ITrait)secondTrait, partType);
    }

    public void addTraits(Material material, AbstractTrait trait, String partType) {
        material.addTrait((ITrait)trait, partType);
    }

    public void addTraits(Material material, AbstractTrait trait, boolean armor) {
        material.addTrait((ITrait)trait, ArmorMaterialType.PLATES);
        material.addTrait((ITrait)trait, ArmorMaterialType.TRIM);
    }

    public void addStats(Material material, float coreDurability, float defense, float plateModifier, float plateDurability, float plateToughness, float trimDurability) {
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new CoreMaterialStats(coreDurability, defense), (IMaterialStats[])new IMaterialStats[]{new PlatesMaterialStats(plateModifier, plateDurability, plateToughness), new TrimMaterialStats(trimDurability)});
    }
}

