/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.registry;

import be.nevoka.core.core.NevokaSettings;
import be.nevoka.core.registry.ContentCategories;
import be.nevoka.core.registry.Plugin;
import be.nevoka.core.registry.TabDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.creativetab.CreativeTabs;

public class ContentRegistry {
    public static Class<TabDetails> tabDetails = TabDetails.class;
    private static List<Plugin> pluginList = Lists.newArrayList();
    private static List<TabDetails> tabList = Lists.newArrayList();

    public static void registerPlugin(Plugin plugin) {
        pluginList.add(plugin);
    }

    public static ListIterator<Plugin> getPluginsIterator() {
        return pluginList.listIterator();
    }

    public static void registerTab(Plugin plugin, CreativeTabs tab, String name, ContentCategories.CreativeTab category) {
        TabDetails details = new TabDetails(plugin, tab, name, category);
        tabList.add(details);
        plugin.tabsList.add(details);
    }

    public static boolean isPluginLoaded(String pluginName) {
        for (Plugin plugin : pluginList) {
            if (!plugin.getModId().equals(pluginName)) continue;
            return true;
        }
        return false;
    }

    public static Plugin getPlugin(String pluginName) {
        for (Plugin plugin : pluginList) {
            if (!plugin.getModId().equals(pluginName)) continue;
            return plugin;
        }
        return null;
    }

    public static List<CreativeTabs> getPluginTabs(String pluginName) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (TabDetails details : plugin.tabsList) {
            list.add(details.tab);
        }
        return list;
    }

    public static List<CreativeTabs> getPluginTabs(String pluginName, ContentCategories.CreativeTab category) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (TabDetails details : plugin.tabsList) {
            if (details.category != category) continue;
            list.add(details.tab);
        }
        return list;
    }

    public static boolean doesTabExist(String tabName) {
        for (TabDetails tab : tabList) {
            if (!tab.name.equals(tabName)) continue;
            return true;
        }
        return false;
    }

    public static CreativeTabs getTab(String tabName) {
        for (TabDetails details : tabList) {
            if (!details.name.equals(tabName)) continue;
            return details.tab;
        }
        return null;
    }

    public static CreativeTabs getFirstTabInCategory(ContentCategories.CreativeTab category) {
        for (TabDetails details : tabList) {
            if (details.category != category) continue;
            return details.tab;
        }
        if (!NevokaSettings.separateTabs && NevokaSettings.tabs && !tabList.isEmpty()) {
            return ContentRegistry.tabList.get((int)0).tab;
        }
        return null;
    }

    public static CreativeTabs getFirstTabInCategory(ContentCategories.CreativeTab category, Plugin plugin) {
        for (TabDetails details : tabList) {
            if (details.category != category || details.plugin != plugin) continue;
            return details.tab;
        }
        return null;
    }
}

