/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.helpers.game;

import be.nevoka.core.logger.LogHelper;
import java.util.IllegalFormatException;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;

public final class Translator {
    private Translator() {
    }

    public static String translateToLocal(String key) {
        if (I18n.func_188566_a((String)key)) {
            return I18n.func_135052_a((String)key, (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static String translateToLocalFormatted(String key, Object ... format) {
        String s = Translator.translateToLocal(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            LogHelper.severe("Format error: " + s);
            LogHelper.verboseException(e);
            return "Format error: " + s;
        }
    }

    public static String toLowercaseWithLocale(String string) {
        return string.toLowerCase(Translator.getLocale());
    }

    private static Locale getLocale() {
        Language currentLanguage;
        LanguageManager languageManager;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && (languageManager = minecraft.func_135016_M()) != null && (currentLanguage = languageManager.func_135041_c()) != null) {
            return currentLanguage.getJavaLocale();
        }
        return Locale.getDefault();
    }
}

