/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.core;

import be.nevoka.core.config.ConfigHelper;
import be.nevoka.core.config.types.ConfigBlock;
import be.nevoka.core.logger.LogHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class NevokaSettings {
    public static Configuration settings;
    public static boolean verboseLogging;
    public static boolean createTestFurnace;
    public static boolean tabs;
    public static boolean separateTabs;
    public static boolean customGeneration;
    public static ConfigBlock testFurnace;

    public static void createOrLoadSettings(FMLPreInitializationEvent event) {
        LogHelper.verbose("nevokacore", "Loading API Settings...");
        settings = ConfigHelper.GetConfig(event, "Nevoka", "nevokacore.cfg");
        try {
            settings.load();
            ConfigHelper.createHelpEntry(settings, "https://minecraft.curseforge.com/projects/nevoka-core");
            verboseLogging = settings.getBoolean("VerboseLogging", "general", true, "Turn on verbose logging");
            tabs = settings.getBoolean("Tabs", "general", true, "If true, have a Nevoka Ores creative tab; if false, put stuff in vanilla tabs");
            separateTabs = settings.getBoolean("SeparateTabs", "general", true, "Use separate creative tabs for each category");
            createTestFurnace = settings.getBoolean("createTestFurnace", "general", false, "create test furnace for testing furnace code");
            if (createTestFurnace) {
                testFurnace = new ConfigBlock("Test Furnace", "Machines").setHardness(3.5f).setResistance(12.0f).setLightValue(1.0f).setHarvestTool("pickaxe");
                testFurnace.GetConfig(settings);
            }
        }
        catch (Exception e) {
            LogHelper.warning("nevokacore", "Failed to load Core settings");
            e.printStackTrace();
        }
        finally {
            if (settings.hasChanged()) {
                settings.save();
            }
            LogHelper.verbose("nevokacore", "Settings loaded successfully");
        }
    }
}

