/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.core;

import be.nevoka.core.content.inventory.NevokaTab;
import be.nevoka.core.core.ModBlocks;
import be.nevoka.core.core.NevokaSettings;
import be.nevoka.core.helpers.game.OreGenerator;
import be.nevoka.core.helpers.game.TabHelper;
import be.nevoka.core.helpers.game.TestFurnaceGuiHandler;
import be.nevoka.core.logger.LogHelper;
import be.nevoka.core.proxy.ProxyCommon;
import be.nevoka.core.registry.ContentCategories;
import be.nevoka.core.registry.ContentRegistry;
import be.nevoka.core.registry.Plugin;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="nevokacore", name="Nevoka Core Mod", version="1.0.2", dependencies="", acceptedMinecraftVersions="[1.12,)", updateJSON="")
public class NevokaCoreAPI {
    @SidedProxy(clientSide="be.nevoka.core.proxy.ProxyClient", serverSide="be.nevoka.core.proxy.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance
    public static NevokaCoreAPI instance;
    public static Plugin plugin;
    public static Plugin vanilla;
    private static boolean iconsSet;
    private static NevokaTab nevokaBlocks;
    private static NevokaTab nevokaDecorations;
    private static NevokaTab nevokaMaterials;
    private static NevokaTab nevokaTools;
    private static NevokaTab nevokaCombat;
    private static NevokaTab nevokaMachines;

    public NevokaCoreAPI() {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.info("Nevoka Core Loading...");
        NevokaSettings.createOrLoadSettings(event);
        LogHelper.loggerSetup();
        if (!NevokaSettings.tabs) {
            this.addVanillaTabs();
        }
        try {
            ModBlocks.configureBlocks();
        }
        catch (Exception e) {
            LogHelper.severe("Nevoka Core Mod", "Content pre-init failed. This is a serious problem!");
            e.printStackTrace();
        }
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new TestFurnaceGuiHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)1);
        proxy.load(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LogHelper.info("Nevoka Core Loading Complete!");
    }

    public static void tabPreInit() {
        LogHelper.verbose("Creating tabs");
        if (NevokaSettings.tabs) {
            nevokaBlocks = new NevokaTab(plugin, "NevokaBlocks", ContentCategories.CreativeTab.BLOCKS);
            if (NevokaSettings.separateTabs) {
                nevokaDecorations = new NevokaTab(plugin, "NevokaDecorations", ContentCategories.CreativeTab.DECORATIONS);
                nevokaMaterials = new NevokaTab(plugin, "NevokaMaterials", ContentCategories.CreativeTab.MATERIALS);
                nevokaTools = new NevokaTab(plugin, "NevokaTools", ContentCategories.CreativeTab.TOOLS);
                nevokaCombat = new NevokaTab(plugin, "NevokaCombat", ContentCategories.CreativeTab.COMBAT);
                nevokaMachines = new NevokaTab(plugin, "NevokaMachines", ContentCategories.CreativeTab.REDSTONE);
            }
        }
        TabHelper.setTabInitDone(true);
    }

    public static void setTabIcons(List<Item> iconItemsList) {
        if (!iconsSet) {
            iconsSet = true;
            if (NevokaSettings.tabs) {
                nevokaBlocks.setIcon(iconItemsList.get(0));
                if (NevokaSettings.separateTabs) {
                    nevokaDecorations.setIcon(iconItemsList.get(1));
                    nevokaMaterials.setIcon(iconItemsList.get(2));
                    nevokaTools.setIcon(iconItemsList.get(3));
                    nevokaCombat.setIcon(iconItemsList.get(4));
                    nevokaMachines.setIcon(iconItemsList.get(5));
                }
            }
        }
    }

    private void addVanillaTabs() {
        LogHelper.verbose("Adding vanilla tabs to ContentRegistry");
        ContentRegistry.registerPlugin(vanilla);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78030_b, CreativeTabs.field_78030_b.func_78013_b(), ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78026_f, CreativeTabs.field_78026_f.func_78013_b(), ContentCategories.CreativeTab.OTHER);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78038_k, CreativeTabs.field_78038_k.func_78013_b(), ContentCategories.CreativeTab.OTHER);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78037_j, CreativeTabs.field_78037_j.func_78013_b(), ContentCategories.CreativeTab.COMBAT);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78031_c, CreativeTabs.field_78031_c.func_78013_b(), ContentCategories.CreativeTab.DECORATIONS);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78039_h, CreativeTabs.field_78039_h.func_78013_b(), ContentCategories.CreativeTab.OTHER);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78035_l, CreativeTabs.field_78035_l.func_78013_b(), ContentCategories.CreativeTab.MATERIALS);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78028_d, CreativeTabs.field_78028_d.func_78013_b(), ContentCategories.CreativeTab.REDSTONE);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78040_i, CreativeTabs.field_78040_i.func_78013_b(), ContentCategories.CreativeTab.TOOLS);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78029_e, CreativeTabs.field_78029_e.func_78013_b(), ContentCategories.CreativeTab.OTHER);
    }

    static {
        plugin = new Plugin("nevokacore", "Nevoka Core Mod");
        vanilla = new Plugin("minecraft", "Minecraft");
        iconsSet = false;
    }
}

