/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.content.tiles;

import be.nevoka.core.content.blocks.NevokaFurnace;
import be.nevoka.core.helpers.game.FurnaceHelper;
import be.nevoka.core.helpers.game.NevokaItemStackHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityNevokaFurnace
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    public static final int NDX_INPUT_SLOT = 0;
    public static final int NDX_FUEL_SLOT = 1;
    public static final int NDX_OUTPUT_SLOT = 2;
    protected static int[] slotsTop = new int[]{0};
    protected static int[] slotsBottom = new int[]{2, 1};
    protected static int[] slotsSides = new int[]{1};
    protected NonNullList<ItemStack> furnaceItemStacks;
    protected int furnaceBurnTime;
    public static final int FIELD_BURN_TIME = 0;
    protected int currentItemBurnTime;
    public static final int FIELD_ITEM_BURN_TIME = 1;
    protected int cookTime;
    public static final int FIELD_COOK_TIME = 2;
    protected int totalCookTime;
    public static final int FIELD_TOTAL_COOK_TIME = 3;
    protected int maxCookTime;
    protected String furnaceCustomName;
    protected String furnaceName;
    protected String furnaceGuiId;
    protected EntityPlayer player;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntityNevokaFurnace(String tileName, int max_cook_time, String guiID, int furnace_stack_count) {
        this.furnaceName = tileName;
        this.maxCookTime = max_cook_time;
        this.furnaceGuiId = guiID;
        this.furnaceItemStacks = NonNullList.func_191197_a((int)furnace_stack_count, (Object)ItemStack.field_190927_a);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = this.func_70301_a(1);
        return this.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public int getMaxCookTime() {
        return this.maxCookTime;
    }

    public void setMaxCookTime(int maxCookTime) {
        this.maxCookTime = maxCookTime;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.furnaceItemStacks.clear();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : this.furnaceName;
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && this.furnaceCustomName.isEmpty();
    }

    public void setCustomInventoryName(String name) {
        this.furnaceCustomName = name;
    }

    public static void registerFixesFurnace(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityNevokaFurnace.class, new String[]{"Items"}));
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFurnace(playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return this.furnaceGuiId;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public void func_73660_a() {
        boolean was_burning_flag = this.isBurning();
        boolean flag1 = false;
        int burnTime = 0;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.func_145831_w().field_72995_K) {
            ItemStack fuelstack = this.func_70301_a(1);
            if (!fuelstack.func_190926_b()) {
                burnTime = TileEntityNevokaFurnace.getItemBurnTime(fuelstack);
            }
            flag1 = this.default_cooking_update(flag1, fuelstack, burnTime);
            if (was_burning_flag != this.isBurning()) {
                flag1 = true;
                NevokaFurnace.setState(this.isBurning(), this.func_145831_w(), this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityNevokaFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        NevokaItemStackHelper.write_itemStackToNBT(compound, this.furnaceItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public int getCookTime(ItemStack stack) {
        return this.maxCookTime;
    }

    protected boolean canSmelt() {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = this.func_70301_a(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack instack = this.func_70301_a(0);
            ItemStack result_stack = FurnaceRecipes.func_77602_a().func_151395_a(instack);
            ItemStack outstack = this.func_70301_a(2);
            if (outstack.func_190926_b()) {
                FurnaceHelper.SetInSlot(this.furnaceItemStacks, 2, result_stack.func_77946_l());
            } else if (ItemStack.func_179545_c((ItemStack)outstack, (ItemStack)result_stack)) {
                outstack.func_190917_f(result_stack.func_190916_E());
            }
            if (instack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && instack.func_77960_j() == 1 && !this.func_70301_a(1).func_190926_b() && this.func_70301_a(1).func_77973_b() == Items.field_151133_ar) {
                FurnaceHelper.SetInSlot(this.furnaceItemStacks, 1, new ItemStack(Items.field_151131_as));
            }
            this.func_70298_a(0, 1);
        }
    }

    public static int getItemBurnTime(ItemStack burnItem) {
        if (burnItem.func_190926_b()) {
            return 0;
        }
        Item item = burnItem.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return ForgeEventFactory.getItemBurnTime((ItemStack)burnItem);
    }

    public boolean isItemFuel(ItemStack stack) {
        return TileEntityNevokaFurnace.getItemBurnTime(stack) > 0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    protected boolean default_cooking_update(boolean flag1, ItemStack itemstackFuel, int burnTime) {
        if (this.isBurning() || !itemstackFuel.func_190926_b() && !this.func_70301_a(0).func_190926_b()) {
            if (!this.isBurning() && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = burnTime;
                if (this.isBurning()) {
                    flag1 = true;
                    if (!itemstackFuel.func_190926_b()) {
                        Item item = itemstackFuel.func_77973_b();
                        itemstackFuel.func_190918_g(1);
                        if (itemstackFuel.func_190926_b()) {
                            ItemStack item1 = item.getContainerItem(itemstackFuel);
                            this.furnaceItemStacks.set(1, (Object)item1);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime == this.totalCookTime) {
                    this.cookTime = 0;
                    this.totalCookTime = this.getCookTime(this.func_70301_a(0));
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
        } else if (!this.isBurning() && this.cookTime > 0) {
            this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
        }
        return flag1;
    }
}

