/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.content.items;

import be.nevoka.core.config.IConfigureItemHelper;
import be.nevoka.core.config.types.ConfigTool;
import be.nevoka.core.core.NevokaCoreAPI;
import be.nevoka.core.helpers.game.TooltipHelper;
import be.nevoka.core.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;

public class NevokaPickaxe
extends ItemPickaxe
implements IConfigureItemHelper<NevokaPickaxe, ConfigTool> {
    protected String name;
    private final Item.ToolMaterial material;
    private Plugin plugin;
    private ConfigTool entry;
    private List<String> toolTipStrings = Lists.newArrayList();

    public NevokaPickaxe(String pickaxeName, Plugin plugin, Item.ToolMaterial material) {
        super(material);
        this.name = pickaxeName;
        this.plugin = plugin;
        this.material = material;
        this.func_77655_b(plugin.getModId() + "." + pickaxeName);
        this.setRegistryName(plugin.getModId(), pickaxeName);
    }

    public void registerItemModel() {
        NevokaCoreAPI.proxy.registerItemRenderer(this.plugin, (Item)this, 0, this.name);
    }

    @Override
    public ConfigTool getConfigEntry() {
        return this.entry;
    }

    @Override
    public NevokaPickaxe setConfigEntry(ConfigTool entry) {
        this.entry = entry;
        this.setHarvestLevel("pickaxe", entry.getHarvestLevel());
        this.setAdditionalProperties();
        return this;
    }

    @Override
    public NevokaPickaxe addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem((Item)this, toolTip);
        return this;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.getRepairItemStack().func_77973_b() == repair.func_77973_b() ? true : super.func_82789_a(toRepair, repair);
    }

    @Override
    public void setAdditionalProperties() {
    }
}

