/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.content.items;

import be.nevoka.core.content.items.BucketVariant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;

public class NevokaBucketType {
    private String material;
    private boolean destroyOnLava = false;
    private List<BucketVariant> variantList = Lists.newArrayList();
    public static int DESTROY_ON_LAVA_TEMP = 1300;

    public NevokaBucketType(String material) {
        this.material = material;
    }

    public boolean getDestroyOnLava() {
        return this.destroyOnLava;
    }

    public void setDestroyOnLava(boolean destroyOnLava) {
        this.destroyOnLava = destroyOnLava;
    }

    public String getMaterial() {
        return this.material;
    }

    public NevokaBucketType addVariant(String name, Item bucket, Fluid fluid) {
        BucketVariant variant = new BucketVariant(name, bucket, fluid);
        this.variantList.add(variant);
        return this;
    }

    public List<Fluid> getLiquidsList() {
        ArrayList liquidList = Lists.newArrayList();
        for (BucketVariant variant : this.variantList) {
            liquidList.add(variant.liquidBlock);
        }
        return liquidList;
    }

    public boolean doesVariantExist(Fluid liquid) {
        for (BucketVariant variant : this.variantList) {
            if (variant.liquidBlock != liquid) continue;
            return true;
        }
        return false;
    }

    public Item getBucketFromLiquid(Fluid liquid) {
        for (BucketVariant variant : this.variantList) {
            if (variant.liquidBlock != liquid) continue;
            return variant.bucket;
        }
        return null;
    }
}

