/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.content.items;

import be.nevoka.core.content.items.NevokaBucketType;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class NevokaBucketFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    protected NevokaBucketType bucketType;
    public static final String FLUID_NBT_KEY = "Fluid";
    protected final ItemStack emptyContainer;
    protected ItemStack container;
    protected final int capacity;

    public NevokaBucketFluidHandler(ItemStack container, ItemStack emptyContainer, int capacity, NevokaBucketType type) {
        this.container = container;
        this.capacity = capacity;
        this.emptyContainer = emptyContainer;
        this.bucketType = type;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.bucketType.doesVariantExist(fluid.getFluid());
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.bucketType.doesVariantExist(fluid.getFluid());
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount < 1000) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        Fluid liquid;
        if (resource == null || resource.amount < 1000 || this.getFluid() != null || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (this.bucketType.getDestroyOnLava() && (liquid = resource.getFluid()).getTemperature() >= NevokaBucketType.DESTROY_ON_LAVA_TEMP) {
            return 0;
        }
        if (doFill) {
            this.setFluid(resource);
        }
        return 1000;
    }

    protected void setFluid(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            this.setContainerToEmpty();
            return;
        }
        if (fluid.getFluid() == FluidRegistry.WATER) {
            this.container = new ItemStack(this.bucketType.getBucketFromLiquid(FluidRegistry.WATER));
            this.container.func_77982_d(null);
        } else if (fluid.getFluid() == FluidRegistry.LAVA && !this.bucketType.getDestroyOnLava()) {
            this.container = new ItemStack(this.bucketType.getBucketFromLiquid(FluidRegistry.LAVA));
            this.container.func_77982_d(null);
        } else {
            this.container = new ItemStack(this.bucketType.getBucketFromLiquid(fluid.getFluid()));
            if (!this.container.func_77942_o()) {
                this.container.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound fluidTag = new NBTTagCompound();
            fluid.writeToNBT(fluidTag);
            this.container.func_77978_p().func_74782_a(FLUID_NBT_KEY, (NBTBase)fluidTag);
        }
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.container.func_185136_b(this.emptyContainer)) {
            return null;
        }
        if (this.container.func_77973_b() == this.bucketType.getBucketFromLiquid(FluidRegistry.WATER)) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (this.container.func_77973_b() == this.bucketType.getBucketFromLiquid(FluidRegistry.LAVA)) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        NBTTagCompound tagCompound = this.container.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b(FLUID_NBT_KEY)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l(FLUID_NBT_KEY));
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    protected void setContainerToEmpty() {
        if (this.container.func_77942_o()) {
            this.container.func_77978_p().func_82580_o(FLUID_NBT_KEY);
        } else {
            this.container.deserializeNBT(this.emptyContainer.serializeNBT());
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

