/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.content.items;

import be.nevoka.core.content.items.NevokaBucketFluidHandler;
import be.nevoka.core.content.items.NevokaBucketType;
import be.nevoka.core.core.NevokaCoreAPI;
import be.nevoka.core.helpers.game.TooltipHelper;
import be.nevoka.core.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class NevokaBucket
extends Item {
    protected String name;
    protected Plugin plugin;
    protected List<String> toolTipStrings = Lists.newArrayList();
    protected final int capacity;
    protected final ItemStack empty;
    protected final NevokaBucketType bucketType;

    public NevokaBucket(String itemName, Plugin plugin, ItemStack empty, NevokaBucketType type) {
        this.name = itemName;
        this.capacity = 1000;
        this.bucketType = type;
        this.plugin = plugin;
        this.func_77625_d(1);
        if (empty == null) {
            this.empty = new ItemStack((Item)this);
        } else {
            this.empty = empty;
            this.func_77642_a(empty.func_77973_b());
        }
        this.func_77655_b(plugin.getModId() + "." + itemName);
        this.setRegistryName(plugin.getModId(), itemName);
    }

    public void registerItemModel() {
        NevokaCoreAPI.proxy.registerItemRenderer(this.plugin, this, 0, this.name);
    }

    public NevokaBucket addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem(this, toolTip);
        return this;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new NevokaBucketFluidHandler(stack, this.empty, this.capacity, this.bucketType);
    }

    protected FluidStack getFluid(ItemStack container) {
        NevokaBucketFluidHandler handler = (NevokaBucketFluidHandler)FluidUtil.getFluidHandler((ItemStack)container);
        return handler != null ? handler.getFluid() : null;
    }

    public ItemStack getEmpty() {
        return this.empty;
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack emptyBucket = event.getEmptyBucket();
        if (emptyBucket.func_190926_b() || !emptyBucket.func_77969_a(this.getEmpty())) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.func_178782_a();
        ItemStack singleBucket = emptyBucket.func_77946_l();
        singleBucket.func_190920_e(1);
        FluidActionResult fRes = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)event.getEntityPlayer(), (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        ItemStack filledBucket = fRes.getResult();
        if (!filledBucket.func_190926_b()) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledBucket);
        } else if (this.bucketType.getDestroyOnLava()) {
            IFluidHandler targetFluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
            assert (targetFluidHandler != null);
            Fluid fluid = Objects.requireNonNull(targetFluidHandler.getTankProperties()[0].getContents()).getFluid();
            if (fluid.getTemperature() >= NevokaBucketType.DESTROY_ON_LAVA_TEMP) {
                event.getEntityPlayer().func_184185_a(SoundEvents.field_187659_cY, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                event.setResult(Event.Result.ALLOW);
                event.setFilledBucket(ItemStack.field_190927_a);
            } else {
                event.setCanceled(true);
            }
        } else {
            event.setCanceled(true);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        BlockPos blockpos1;
        ItemStack itemstack;
        FluidStack fluidStack = this.getFluid(itemstack = player.func_184586_b(hand));
        boolean flag = fluidStack == null;
        RayTraceResult mop = this.func_77621_a(world, player, flag);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)itemstack, (RayTraceResult)mop);
        if (ret != null) {
            return ret;
        }
        if (mop == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos clickPos = mop.func_178782_a();
        if (!world.func_175660_a(player, clickPos)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
        }
        if (flag) {
            BlockPos targetPos = clickPos.func_177972_a(mop.field_178784_b);
            if (!player.func_175151_a(targetPos, mop.field_178784_b, itemstack)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
            }
            IBlockState iblockstate = world.func_180495_p(clickPos);
            Material material = iblockstate.func_185904_a();
            if (material == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                world.func_180501_a(clickPos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)this)));
                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                Item water_bucket = this.bucketType.getBucketFromLiquid(FluidRegistry.WATER);
                if (water_bucket == null) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)this.fillBucket(itemstack, player, water_bucket));
            }
            if (material == Material.field_151587_i && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                if (this.bucketType.getDestroyOnLava()) {
                    player.func_184185_a(SoundEvents.field_187659_cY, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    itemstack.func_190918_g(1);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
                }
                Item lava_bucket = this.bucketType.getBucketFromLiquid(FluidRegistry.LAVA);
                if (lava_bucket == null) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
                }
                player.func_184185_a(SoundEvents.field_187633_N, 1.0f, 1.0f);
                world.func_180501_a(clickPos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)this.fillBucket(itemstack, player, lava_bucket));
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
        }
        boolean flag1 = world.func_180495_p(clickPos).func_177230_c().func_176200_f((IBlockAccess)world, clickPos);
        BlockPos blockPos = blockpos1 = flag1 && mop.field_178784_b == EnumFacing.UP ? clickPos : clickPos.func_177972_a(mop.field_178784_b);
        if (!player.func_175151_a(blockpos1, mop.field_178784_b, itemstack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
        }
        if (this.tryPlaceContainedLiquid(player, player.func_130014_f_(), blockpos1, fluidStack)) {
            ItemStack emptyStack;
            player.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)this)));
            if (player.field_71075_bZ.field_75098_d) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
            }
            itemstack.func_190918_g(1);
            ItemStack itemStack = emptyStack = this.getEmpty() != null ? this.getEmpty().func_77946_l() : new ItemStack((Item)this);
            if (itemstack.func_190926_b()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)emptyStack);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
    }

    public boolean tryPlaceContainedLiquid(@Nullable EntityPlayer player, World world, BlockPos posIn, FluidStack fluidStack) {
        if (this == this.getEmpty().func_77973_b()) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(posIn);
        Material material = iblockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = iblockstate.func_177230_c().func_176200_f((IBlockAccess)world, posIn);
        if (!(world.func_175623_d(posIn) || flag || flag1)) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && fluidStack.getFluid() == FluidRegistry.WATER) {
            int l = posIn.func_177958_n();
            int i = posIn.func_177956_o();
            int j = posIn.func_177952_p();
            world.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!world.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                world.func_175655_b(posIn, true);
            }
            SoundEvent soundevent = fluidStack.getFluid() == FluidRegistry.LAVA ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
            world.func_184133_a(player, posIn, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            Object fluidBlock = fluidStack.getFluid() == FluidRegistry.LAVA ? Blocks.field_150356_k : (fluidStack.getFluid() == FluidRegistry.WATER ? Blocks.field_150358_i : fluidStack.getFluid().getBlock());
            world.func_180501_a(posIn, fluidBlock.func_176223_P(), 11);
        }
        return true;
    }

    protected ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        emptyBuckets.func_190918_g(1);
        if (emptyBuckets.func_190926_b()) {
            return new ItemStack(fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(fullBucket))) {
            player.func_71019_a(new ItemStack(fullBucket), false);
        }
        return emptyBuckets;
    }
}

