/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.core.content.items;

import be.nevoka.core.config.IConfigureItemHelper;
import be.nevoka.core.config.types.ConfigTool;
import be.nevoka.core.core.NevokaCoreAPI;
import be.nevoka.core.helpers.game.TooltipHelper;
import be.nevoka.core.registry.Plugin;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;

public class NevokaAxe
extends ItemAxe
implements IConfigureItemHelper<NevokaAxe, ConfigTool> {
    private final Item.ToolMaterial material;
    private Plugin plugin;
    private ConfigTool entry;
    private List<String> toolTipStrings = Lists.newArrayList();
    protected String name;

    public NevokaAxe(String axeName, Plugin plugin, Item.ToolMaterial material, float damage, float speed) {
        super(material, damage, speed);
        this.name = axeName;
        this.plugin = plugin;
        this.material = material;
        this.func_77655_b(plugin.getModId() + "." + axeName);
        this.setRegistryName(plugin.getModId(), axeName);
    }

    public NevokaAxe(String axeName, Plugin plugin, Item.ToolMaterial material) {
        super(material, NevokaAxe.getAttackDamage(material), NevokaAxe.getAttackSpeed(material));
        this.name = axeName;
        this.plugin = plugin;
        this.material = material;
        this.func_77655_b(axeName);
        this.setRegistryName(plugin.getModId(), axeName);
    }

    protected static float getAttackDamage(Item.ToolMaterial m) {
        return 2 * (int)Math.rint(0.5 * ((double)m.func_78000_c() * 0.7058823529 + 6.352941176));
    }

    protected static float getAttackSpeed(Item.ToolMaterial m) {
        return NevokaAxe.roundToFloatDecimal((double)((float)m.func_77996_d() + m.func_77998_b()) * 0.02312138728 - 3.275722543, RoundingMode.HALF_EVEN, 1);
    }

    protected static float roundToFloatDecimal(double a, RoundingMode mode, int precision) {
        return new BigDecimal(a).round(new MathContext(precision, mode)).floatValue();
    }

    public void registerItemModel() {
        NevokaCoreAPI.proxy.registerItemRenderer(this.plugin, (Item)this, 0, this.name);
    }

    @Override
    public ConfigTool getConfigEntry() {
        return this.entry;
    }

    @Override
    public NevokaAxe setConfigEntry(ConfigTool entry) {
        this.entry = entry;
        this.setHarvestLevel("axe", entry.getHarvestLevel());
        this.setAdditionalProperties();
        return this;
    }

    @Override
    public NevokaAxe addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem((Item)this, toolTip);
        return this;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ItemStack.func_77989_b((ItemStack)this.material.getRepairItemStack(), (ItemStack)repair) || super.func_82789_a(toRepair, repair);
    }

    @Override
    public void setAdditionalProperties() {
    }
}

