/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.integration.constructs_armory;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import org.softc.armoryexpansion.integration.tinkers_construct.TiCMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class ConArmStats {
    private ConArmStats() {
    }

    private static CoreMaterialStats getCoreMaterialStats(float durability, float defense) {
        return new CoreMaterialStats(durability, defense * 2.0f);
    }

    private static PlatesMaterialStats getPlatesMaterialStats(float magicaffinity, float durability, float toughness) {
        return new PlatesMaterialStats(magicaffinity / 8.0f, durability, toughness * 1.5f);
    }

    private static TrimMaterialStats getTrimMaterialStats(float extra) {
        return new TrimMaterialStats(extra / 8.0f);
    }

    private static void registerMaterialArmorStats(Material material, float durability, float defense, float toughness, float magicaffinity, float extra) {
        if (!material.hasStats(ArmorMaterialType.CORE)) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)ConArmStats.getCoreMaterialStats(durability, defense));
        }
        if (!material.hasStats(ArmorMaterialType.TRIM)) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)ConArmStats.getTrimMaterialStats(extra));
        }
        if (!material.hasStats(ArmorMaterialType.PLATES)) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)ConArmStats.getPlatesMaterialStats(magicaffinity, durability, toughness));
        }
    }

    private static void registerMaterialArmorStats(String identifier, float durability, float defense, float toughness, float magicaffinity, float extra) {
        Material material = TinkerRegistry.getMaterial((String)identifier);
        if (material.identifier.equals("unknown")) {
            return;
        }
        ConArmStats.registerMaterialArmorStats(material, durability, defense, toughness, magicaffinity, extra);
    }

    public static void registerMaterialArmorStats(TiCMaterial material) {
        ConArmStats.registerMaterialArmorStats(material.getIdentifier(), (float)material.getDurability(), material.getDefense(), material.getToughness(), material.getMagicaffinity(), (float)material.getDurability());
    }
}

