/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.integration;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.softc.armoryexpansion.integration.IIntegration;
import org.softc.armoryexpansion.integration.ice_and_fire.IceAndFire;

@Mod(modid="armoryexpansionintegrations", name="Armory Expansion Integrations", version="1.1.5", dependencies="required-after:tconstruct; required-after:conarm;", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class Integrations {
    static final String MODID = "armoryexpansionintegrations";
    static final String NAME = "Armory Expansion Integrations";
    static final String DEPENDENCIES = "required-after:tconstruct; required-after:conarm;";
    static List<IIntegration> integrationList = new LinkedList<IIntegration>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.initIntegrations();
        for (IIntegration integration : integrationList) {
            if (!Loader.isModLoaded((String)integration.getModId())) continue;
            integration.preInit(event);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (IIntegration integration : integrationList) {
            if (!Loader.isModLoaded((String)integration.getModId())) continue;
            integration.init(event);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (IIntegration integration : integrationList) {
            if (!Loader.isModLoaded((String)integration.getModId())) continue;
            integration.registerItems(event);
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (IIntegration integration : integrationList) {
            if (!Loader.isModLoaded((String)integration.getModId())) continue;
            integration.registerRecipes(event);
        }
    }

    private void initIntegrations() {
        new IceAndFire();
    }
}

