/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.dynamic_systems.dynamic_materials.constructs_armory;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import org.softc.armoryexpansion.dynamic_systems.dynamic_materials.Config;
import org.softc.armoryexpansion.util.Math;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.tools.TinkerMaterials;

final class StatRegistration {
    private static final float STAT_MULT = 1.25f;
    private static final int DURA_MIN = 1;
    private static final int DURA_MAX = 120;
    private static final int DEF_MIN = 0;
    private static final int DEF_MAX = 50;
    private static final int TOUGH_MIN = 0;
    private static final int TOUGH_MAX = 5;

    StatRegistration() {
    }

    private static void registerCoreMaterialStat(Material material) {
        HeadMaterialStats materialHead = (HeadMaterialStats)material.getStats("head");
        HeadMaterialStats ironHead = (HeadMaterialStats)TinkerMaterials.iron.getStats("head");
        CoreMaterialStats ironCore = (CoreMaterialStats)TinkerMaterials.iron.getStats(ArmorMaterialType.CORE);
        float durability = Math.clamp(ironCore.durability * (float)materialHead.durability / (float)ironHead.durability / 1.25f, 1.0f, 120.0f);
        float defense = Math.clamp(1.5f * ironCore.defense * materialHead.attack / ironHead.attack / 1.25f, 0.0f, 50.0f);
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new CoreMaterialStats(durability, defense));
    }

    private static void registerPlatesMaterialStat(Material material) {
        HandleMaterialStats materialHandle = (HandleMaterialStats)material.getStats("handle");
        HandleMaterialStats ironHandle = (HandleMaterialStats)TinkerMaterials.iron.getStats("handle");
        PlatesMaterialStats ironPlates = (PlatesMaterialStats)TinkerMaterials.iron.getStats(ArmorMaterialType.PLATES);
        float ironPlatesToughness = ironPlates.toughness > 0.0f ? ironPlates.toughness : 1.0f;
        float durability = Math.clamp(ironPlates.durability * (float)materialHandle.durability / (float)ironHandle.durability / 1.25f, 1.0f, 120.0f);
        float toughness = Math.clamp(3.0f * ironPlatesToughness * (float)materialHandle.durability / (float)ironHandle.durability / 1.25f, 0.0f, 5.0f);
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new PlatesMaterialStats(materialHandle.modifier, durability, toughness));
    }

    private static void registerTrimMaterialStat(Material material) {
        ExtraMaterialStats materialExtra = (ExtraMaterialStats)material.getStats("extra");
        ExtraMaterialStats ironExtra = (ExtraMaterialStats)TinkerMaterials.iron.getStats("extra");
        TrimMaterialStats ironTrim = (TrimMaterialStats)TinkerMaterials.iron.getStats(ArmorMaterialType.TRIM);
        float extra = 2.0f * ironTrim.extraDurability * (float)materialExtra.extraDurability / (float)ironExtra.extraDurability / 1.25f;
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new TrimMaterialStats(extra));
    }

    private static Boolean handleCoreStats(int index, Material material) {
        if (Config.hasCoreProperty(index).booleanValue() && Config.getCoreProperty(index).getBoolean()) {
            StatRegistration.registerCoreMaterialStat(material);
            return true;
        }
        return false;
    }

    private static Boolean handlePlatesStats(int index, Material material) {
        if (Config.hasPlatesProperty(index).booleanValue() && Config.getPlatesProperty(index).getBoolean()) {
            StatRegistration.registerPlatesMaterialStat(material);
            return true;
        }
        return false;
    }

    private static Boolean handleTrimStats(int index, Material material) {
        if (Config.hasTrimProperty(index).booleanValue() && Config.getTrimProperty(index).getBoolean()) {
            StatRegistration.registerTrimMaterialStat(material);
            return true;
        }
        return false;
    }

    static Boolean handleArmorStats(int index, Material material) {
        if (Config.hasMaterialProperty(index).booleanValue() && Config.getMaterialProperty(index).getBoolean()) {
            StatRegistration.handleCoreStats(index, material);
            StatRegistration.handlePlatesStats(index, material);
            StatRegistration.handleTrimStats(index, material);
            return true;
        }
        return false;
    }
}

