/*
 * Decompiled with CFR 0.152.
 */
package hu.frontrider.core.util.inventory;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lhu/frontrider/core/util/inventory/InventoryChooser;", "", "()V", "getBlockInventory", "Ljava/util/Optional;", "Lnet/minecraftforge/items/IItemHandler;", "world", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "facing", "Lnet/minecraft/util/EnumFacing;", "getEntityInventory", "getInventory", "Thaumic Arcana"})
public final class InventoryChooser {
    public static final InventoryChooser INSTANCE;

    @NotNull
    public final Optional<IItemHandler> getInventory(@NotNull World world, @NotNull BlockPos blockPos, @NotNull EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"blockPos");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        Optional<IItemHandler> blockInventory = this.getBlockInventory(world, blockPos, facing);
        if (blockInventory.isPresent()) {
            return blockInventory;
        }
        Optional<IItemHandler> entityInventory = this.getEntityInventory(world, blockPos, facing);
        if (entityInventory.isPresent()) {
            return entityInventory;
        }
        Optional<IItemHandler> optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        return optional;
    }

    private final Optional<IItemHandler> getBlockInventory(World world, BlockPos blockPos, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity == null) {
            Optional<IItemHandler> optional = Optional.empty();
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
            return optional;
        }
        TileEntity tileEntity2 = tileEntity;
        if (tileEntity2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            Object object = tileEntity2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            IItemHandler iItemHandler = (IItemHandler)object;
            Optional<IItemHandler> optional = Optional.of(iItemHandler);
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(iItemHandler)");
            return optional;
        }
        Optional<IItemHandler> optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        return optional;
    }

    private final Optional<IItemHandler> getEntityInventory(World world, BlockPos blockPos, EnumFacing facing) {
        for (Entity entity : world.func_72872_a(Entity.class, new AxisAlignedBB(blockPos))) {
            if (!entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) continue;
            Object object = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            IItemHandler iItemHandler = (IItemHandler)object;
            Optional<IItemHandler> optional = Optional.of(iItemHandler);
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(iItemHandler)");
            return optional;
        }
        Optional<IItemHandler> optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        return optional;
    }

    private InventoryChooser() {
    }

    static {
        InventoryChooser inventoryChooser;
        INSTANCE = inventoryChooser = new InventoryChooser();
    }
}

