/*
 * Decompiled with CFR 0.152.
 */
package hu.frontrider.arcana.client.rendering;

import hu.frontrider.arcana.ThaumicArcana;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ0\u0010\u0011\u001a\u00020\r2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u0017H\u0002R.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lhu/frontrider/arcana/client/rendering/CreatureEnchantOffsetManager;", "", "()V", "offsets", "", "", "Lorg/apache/commons/lang3/tuple/Triple;", "", "getForEntity", "resourceLocation", "entityLivingBase", "Lnet/minecraft/entity/EntityLivingBase;", "initDefaults", "", "properties", "Ljava/util/Properties;", "loadConfigs", "reportError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "languageKey", "message", "Lkotlin/Function0;", "", "Thaumic Arcana"})
public final class CreatureEnchantOffsetManager {
    private Map<String, Triple<Float, Float, Float>> offsets;

    public final void loadConfigs() {
        File file = new File(ThaumicArcana.INSTANCE.getConfigDirectory().getAbsolutePath() + "/enchantingCircleOffsets.properties");
        Properties offsetProperties = new Properties();
        if (!file.exists()) {
            this.initDefaults(offsetProperties);
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                offsetProperties.store(new FileOutputStream(file), "This file contains the offsets that are used to render the enchantment circles.\nSome entities may render their circles above their heads, or in the ground.This file provides a fix for that.");
            }
            catch (IOException e) {
                this.reportError(e, "rendering.thaumic_arcana.reload.failed", (Function0<String[]>)((Function0)new Function0<String[]>(file){
                    final /* synthetic */ File $file;

                    @NotNull
                    public final String[] invoke() {
                        return new String[]{"config file:" + this.$file.getAbsolutePath()};
                    }
                    {
                        this.$file = file;
                        super(0);
                    }
                }));
            }
        } else {
            try {
                offsetProperties.load(new FileInputStream(file));
            }
            catch (IOException e) {
                this.reportError(e, "rendering.thaumic_arcana.reload.failed", (Function0<String[]>)((Function0)new Function0<String[]>(file){
                    final /* synthetic */ File $file;

                    @NotNull
                    public final String[] invoke() {
                        return new String[]{"config file:" + this.$file.getAbsolutePath()};
                    }
                    {
                        this.$file = file;
                        super(0);
                    }
                }));
            }
        }
        if (this.offsets == null) {
            this.offsets = new HashMap();
        } else {
            Map<String, Triple<Float, Float, Float>> map = this.offsets;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            map.clear();
        }
        offsetProperties.forEach((BiConsumer<? super Object, ? super Object>)new BiConsumer<Object, Object>(this){
            final /* synthetic */ CreatureEnchantOffsetManager this$0;

            public final void accept(Object key, Object value) {
                try {
                    List list;
                    Collection $receiver$iv;
                    Object object = value.toString();
                    String string = ",";
                    string = new Regex(string);
                    int n = 0;
                    object = string.split((CharSequence)object, n);
                    if (!$receiver$iv.isEmpty()) {
                        ListIterator<E> iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            CharSequence charSequence = it;
                            if (charSequence.length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $receiver$iv = list;
                    Collection collection = $receiver$iv;
                    if (collection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = collection;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray;
                    Map map = CreatureEnchantOffsetManager.access$getOffsets$p(this.this$0);
                    if (map == null) {
                        Intrinsics.throwNpe();
                    }
                    object = map;
                    string = key.toString();
                    ImmutableTriple immutableTriple = new ImmutableTriple((Object)Float.valueOf(split[0]), (Object)Float.valueOf(split[1]), (Object)Float.valueOf(split[2]));
                    object.put(string, immutableTriple);
                }
                catch (Exception e) {
                    CreatureEnchantOffsetManager.access$reportError(this.this$0, e, "rendering.thaumic_arcana.reload.failed", (Function0)new Function0<String[]>(key, value){
                        final /* synthetic */ Object $key;
                        final /* synthetic */ Object $value;

                        @NotNull
                        public final String[] invoke() {
                            return new String[]{"key: " + this.$key, "value: " + this.$value};
                        }
                        {
                            this.$key = object;
                            this.$value = object2;
                            super(0);
                        }
                    });
                }
            }
            {
                this.this$0 = creatureEnchantOffsetManager;
            }
        });
    }

    public final void initDefaults(@NotNull Properties properties) {
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        properties.setProperty("minecraft:VillagerGolem", "0,1,0");
        properties.setProperty("minecraft:sheep", "0,1.5,0");
        properties.setProperty("minecraft:cow", "0,1.5,0");
        properties.setProperty("minecraft:chicken", "0,1.5,0");
        properties.setProperty("minecraft:shulker", "0,1.5,0");
        properties.setProperty("minecraft:witherSkeleton", "0,1.5,0");
        properties.setProperty("minecraft:guardian", "0,1.4,0");
    }

    @NotNull
    public final Triple<Float, Float, Float> getForEntity(@NotNull String resourceLocation, @Nullable EntityLivingBase entityLivingBase) {
        Triple triple;
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        float height = 0.0f;
        if (entityLivingBase != null) {
            height = (float)((double)entityLivingBase.field_70131_O - 0.5);
        }
        Map<String, Triple<Float, Float, Float>> map = this.offsets;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        if (map.containsKey(resourceLocation)) {
            Map<String, Triple<Float, Float, Float>> map2 = this.offsets;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            Triple triple2 = map2.get(resourceLocation);
            if (triple2 == null) {
                Intrinsics.throwNpe();
            }
            triple = triple2;
        } else {
            triple = (Triple)new ImmutableTriple((Object)Float.valueOf(0.0f), (Object)Float.valueOf(height), (Object)Float.valueOf(0.0f));
        }
        return triple;
    }

    private final void reportError(Exception e, String languageKey, Function0<String[]> message) {
        EntityPlayerSP player;
        EntityPlayerSP entityPlayerSP = player = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayerSP != null) {
            entityPlayerSP.func_145747_a((ITextComponent)new TextComponentTranslation(languageKey, new Object[0]));
        }
        for (String log : (String[])message.invoke()) {
            ThaumicArcana.INSTANCE.getLogger().error(log);
        }
        ThaumicArcana.INSTANCE.getLogger().error((Object)e.getStackTrace());
    }

    @Nullable
    public static final /* synthetic */ Map access$getOffsets$p(CreatureEnchantOffsetManager $this) {
        return $this.offsets;
    }

    public static final /* synthetic */ void access$setOffsets$p(CreatureEnchantOffsetManager $this, @Nullable Map map) {
        $this.offsets = map;
    }

    public static final /* synthetic */ void access$reportError(CreatureEnchantOffsetManager $this, @NotNull Exception e, @NotNull String languageKey, @NotNull Function0 message) {
        $this.reportError(e, languageKey, (Function0<String[]>)message);
    }
}

