/*
 * Decompiled with CFR 0.152.
 */
package hu.frontrider.arcana.capabilities.creatureenchant;

import hu.frontrider.arcana.capabilities.creatureenchant.CreatureEnchantCapability;
import hu.frontrider.arcana.capabilities.creatureenchant.ICreatureEnchant;
import hu.frontrider.arcana.creatureenchant.CreatureEnchant;
import hu.frontrider.arcana.creatureenchant.EnchantingBaseCircle;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000e"}, d2={"Lhu/frontrider/arcana/capabilities/creatureenchant/CreatureEnchantStorage;", "Lnet/minecraftforge/common/capabilities/Capability$IStorage;", "Lhu/frontrider/arcana/capabilities/creatureenchant/ICreatureEnchant;", "()V", "readNBT", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "instance", "side", "Lnet/minecraft/util/EnumFacing;", "nbt", "Lnet/minecraft/nbt/NBTBase;", "writeNBT", "Thaumic Arcana"})
public final class CreatureEnchantStorage
implements Capability.IStorage<ICreatureEnchant> {
    @Nullable
    public NBTBase writeNBT(@NotNull Capability<ICreatureEnchant> capability, @NotNull ICreatureEnchant instance, @Nullable EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        NBTTagCompound storage = new NBTTagCompound();
        NBTTagList enchantmentNBTList = new NBTTagList();
        Collection<CreatureEnchantCapability.CreatureEnchantContainer> enchants = instance.getStore().values();
        Iterable $receiver$iv = enchants;
        for (Object element$iv : $receiver$iv) {
            CreatureEnchantCapability.CreatureEnchantContainer enchant = (CreatureEnchantCapability.CreatureEnchantContainer)element$iv;
            NBTTagCompound enchantData = new NBTTagCompound();
            enchantData.func_74768_a("level", enchant.getLevel());
            enchantData.func_74768_a("usedTo", enchant.getUsedTo());
            ResourceLocation resourceLocation = enchant.getCreatureEnchant().getRegistryName();
            if (resourceLocation == null) {
                Intrinsics.throwNpe();
            }
            enchantData.func_74778_a("enchant", resourceLocation.toString());
            enchantData.func_74757_a("enabled", enchant.getEnabled());
            enchantmentNBTList.func_74742_a((NBTBase)enchantData);
        }
        storage.func_74782_a("enchants", (NBTBase)enchantmentNBTList);
        ResourceLocation resourceLocation = instance.getCircle().getRegistryName();
        if (resourceLocation == null) {
            Intrinsics.throwNpe();
        }
        storage.func_74778_a("base", resourceLocation.toString());
        return (NBTBase)storage;
    }

    public void readNBT(@NotNull Capability<ICreatureEnchant> capability, @NotNull ICreatureEnchant instance, @Nullable EnumFacing side, @NotNull NBTBase nbt) {
        NBTTagList enchants;
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        if (nbt instanceof NBTTagList) {
            enchants = (NBTTagList)nbt;
        } else {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            NBTBase nBTBase = compound.func_74781_a("enchants");
            if (nBTBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagList");
            }
            enchants = (NBTTagList)nBTBase;
            if (compound.func_74764_b("base")) {
                EnchantingBaseCircle base;
                EnchantingBaseCircle enchantingBaseCircle = base = (EnchantingBaseCircle)GameRegistry.findRegistry(EnchantingBaseCircle.class).getValue(new ResourceLocation(compound.func_74779_i("base")));
                if (enchantingBaseCircle == null) {
                    Intrinsics.throwNpe();
                }
                instance.setCircle(enchantingBaseCircle);
            } else {
                EnchantingBaseCircle base;
                EnchantingBaseCircle enchantingBaseCircle = base = (EnchantingBaseCircle)GameRegistry.findRegistry(EnchantingBaseCircle.class).getValue(new ResourceLocation("thaumic_arcana", "normal"));
                if (enchantingBaseCircle == null) {
                    Intrinsics.throwNpe();
                }
                instance.setCircle(enchantingBaseCircle);
            }
        }
        enchants.iterator().forEachRemaining((Consumer)new Consumer<NBTBase>(instance){
            final /* synthetic */ ICreatureEnchant $instance;

            public final void accept(NBTBase enchant) {
                NBTBase nBTBase = enchant;
                if (nBTBase == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
                }
                String enchantName = ((NBTTagCompound)nBTBase).func_74779_i("enchant");
                int level = ((NBTTagCompound)enchant).func_74762_e("level");
                ResourceLocation enchantment = new ResourceLocation(enchantName);
                CreatureEnchant creatureEnchant = (CreatureEnchant)GameRegistry.findRegistry(CreatureEnchant.class).getValue(enchantment);
                int usedTo = 0;
                if (((NBTTagCompound)enchant).func_74764_b("usedTo")) {
                    usedTo = ((NBTTagCompound)enchant).func_74762_e("usedTo");
                }
                boolean enabled = true;
                if (((NBTTagCompound)enchant).func_74764_b("enabled")) {
                    enabled = ((NBTTagCompound)enchant).func_74767_n("enabled");
                }
                CreatureEnchant creatureEnchant2 = creatureEnchant;
                if (creatureEnchant2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)creatureEnchant2), (String)"creatureEnchant!!");
                CreatureEnchantCapability.CreatureEnchantContainer creatureEnchantContainer = new CreatureEnchantCapability.CreatureEnchantContainer(creatureEnchant2, level, usedTo, enabled);
                this.$instance.putEnchant(creatureEnchantContainer);
            }
            {
                this.$instance = iCreatureEnchant;
            }
        });
    }
}

