/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.fix;

import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="wings")
public final class WingsFixes {
    private static final int DATA_VERSION = 1;
    private static final String WINGS = "wings:wings";
    private static final ResourceLocation WINGS_KEY = new ResourceLocation("wings:wings");

    private WingsFixes() {
    }

    @SubscribeEvent
    public static void onMissingMappings(RegistryEvent.MissingMappings<Item> event) {
        event.getMappings().stream().filter(mapping -> WINGS_KEY.equals((Object)mapping.key)).forEach(RegistryEvent.MissingMappings.Mapping::ignore);
    }

    public static void register() {
        FMLCommonHandler.instance().getDataFixer().func_188258_a(FixTypes.PLAYER, (fixer, compound, version) -> {
            NBTTagCompound caps;
            if (compound.func_150297_b("ForgeCaps", 10) && (caps = compound.func_74775_l("ForgeCaps")).func_150297_b("baubles:container", 10)) {
                DataFixesManager.func_188278_b((IDataFixer)fixer, (NBTTagCompound)caps.func_74775_l("baubles:container"), (int)version, (String)"Items");
            }
            return compound;
        });
        ModFixs fixer2 = FMLCommonHandler.instance().getDataFixer().init("wings", 1);
        fixer2.registerFix((IFixType)FixTypes.ITEM_INSTANCE, new IFixableData(){
            private final String[] lookup = new String[]{"wings:angel_wings", "wings:slime_wings", "wings:blue_butterfly_wings", "wings:monarch_butterfly_wings", "wings:fire_wings", "wings:bat_wings", "wings:fairy_wings", "wings:evil_wings", "wings:dragon_wings"};

            public int func_188216_a() {
                return 1;
            }

            public NBTTagCompound func_188217_a(NBTTagCompound compound) {
                if (compound.func_150297_b("id", 8) && WingsFixes.WINGS.equals(compound.func_74779_i("id"))) {
                    short damage = compound.func_74765_d("Damage");
                    compound.func_74778_a("id", this.lookup[damage >= 0 && damage < this.lookup.length ? (int)damage : 0]);
                    compound.func_74777_a("Damage", (short)0);
                }
                return compound;
            }
        });
    }
}

