/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.dreamcatcher;

import me.paulf.wings.server.dreamcatcher.InSomniable;
import me.paulf.wings.server.dreamcatcher.InSomniableCapability;
import me.paulf.wings.server.dreamcatcher.Playable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="wings")
public final class InSomniableEventHandler {
    private InSomniableEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Playable playable;
        TileEntity entity;
        BlockPos pos;
        World world;
        Block block;
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof EntityPlayerMP && (block = (world = event.getWorld()).func_180495_p(pos = event.getPos()).func_177230_c()) == Blocks.field_150323_B && InSomniableEventHandler.canEdit((EntityPlayerMP)player, block) && (entity = world.func_175625_s(pos)) instanceof TileEntityNote && (playable = InSomniableCapability.getPlayable((TileEntityNote)entity)) != null) {
            playable.setPlayer(player.func_110124_au());
        }
    }

    private static boolean canEdit(EntityPlayerMP player, Block block) {
        GameType gameType = player.field_71134_c.func_73081_b();
        if (!gameType.func_82752_c()) {
            return true;
        }
        if (gameType == GameType.SPECTATOR) {
            return false;
        }
        if (player.func_175142_cm()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        return !stack.func_190926_b() && stack.func_179544_c(block);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onNoteBlockPlay(NoteBlockEvent.Play event) {
        Playable playable;
        TileEntity entity;
        World world = event.getWorld();
        if (!world.field_72995_K && (entity = world.func_175625_s(event.getPos())) instanceof TileEntityNote && (playable = InSomniableCapability.getPlayable((TileEntityNote)entity)) != null) {
            playable.ifPlayerPresent(playerId -> {
                InSomniable inSomniable;
                EntityPlayer player = world.func_152378_a(playerId);
                if (player != null && (inSomniable = InSomniableCapability.getInSomniable(player)) != null) {
                    inSomniable.onPlay(world, player, event.getPos(), event.getVanillaNoteId());
                }
            });
        }
    }
}

