/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.config;

import me.paulf.wings.server.item.ImmutableWingSettings;
import me.paulf.wings.server.item.WingSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;

public final class ConfigWingSettings
implements WingSettings {
    private final ResourceLocation key;
    @Deprecated
    @Config.LangKey(value="config.wings.items.settings.requiredFlightSatiation")
    @Config.RangeInt(min=0, max=20)
    public int requiredFlightSatiation;
    @Deprecated
    @Config.LangKey(value="config.wings.items.settings.flyingExertion")
    @Config.RangeDouble(min=0.0, max=10.0)
    public double flyingExertion;
    @Deprecated
    @Config.LangKey(value="config.wings.items.settings.requiredLandSatiation")
    @Config.RangeInt(min=0, max=20)
    public int requiredLandSatiation;
    @Deprecated
    @Config.LangKey(value="config.wings.items.settings.landingExertion")
    @Config.RangeDouble(min=0.0, max=10.0)
    public double landingExertion;
    @Deprecated
    @Config.LangKey(value="config.wings.items.settings.durability")
    @Config.RangeInt(min=0, max=32767)
    public int itemDurability;

    ConfigWingSettings(ResourceLocation key, int itemDurability) {
        this(key, 7, 0.001, 2, 0.08, itemDurability);
    }

    private ConfigWingSettings(ResourceLocation key, int requiredFlightSatiation, double flyingExertion, int requiredLandSatiation, double landingExertion, int itemDurability) {
        this.key = key;
        this.requiredFlightSatiation = requiredFlightSatiation;
        this.flyingExertion = flyingExertion;
        this.requiredLandSatiation = requiredLandSatiation;
        this.landingExertion = landingExertion;
        this.itemDurability = itemDurability;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    public int getRequiredFlightSatiation() {
        return this.requiredFlightSatiation;
    }

    @Override
    public float getFlyingExertion() {
        return (float)this.flyingExertion;
    }

    @Override
    public int getRequiredLandSatiation() {
        return this.requiredLandSatiation;
    }

    @Override
    public float getLandingExertion() {
        return (float)this.landingExertion;
    }

    @Override
    public int getItemDurability() {
        return this.itemDurability;
    }

    public WingSettings toImmutable() {
        return ImmutableWingSettings.of(this.getRequiredFlightSatiation(), this.getFlyingExertion(), this.getRequiredLandSatiation(), this.getLandingExertion(), this.getItemDurability());
    }
}

