/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.apparatus;

import java.util.function.BiPredicate;
import java.util.function.Function;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.flight.Flight;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public final class SimpleFlightApparatus
implements FlightApparatus {
    private final TravelListener flight;
    private final TravelListener landing;
    private final BiPredicate<EntityPlayer, ItemStack> usability;
    private final BiPredicate<EntityPlayer, ItemStack> landability;
    private final Function<Flight, FlightApparatus.FlightState> vitality;

    private SimpleFlightApparatus(TravelListener flight, TravelListener landing, BiPredicate<EntityPlayer, ItemStack> usability, BiPredicate<EntityPlayer, ItemStack> landability, Function<Flight, FlightApparatus.FlightState> vitality) {
        this.flight = flight;
        this.landing = landing;
        this.usability = usability;
        this.landability = landability;
        this.vitality = vitality;
    }

    @Override
    public void onFlight(EntityPlayer player, ItemStack stack, Vec3d direction) {
        this.flight.onTravel(player, stack, direction);
    }

    @Override
    public void onLanding(EntityPlayer player, ItemStack stack, Vec3d direction) {
        this.landing.onTravel(player, stack, direction);
    }

    @Override
    public boolean isUsable(EntityPlayer player, ItemStack stack) {
        return this.usability.test(player, stack);
    }

    @Override
    public boolean isLandable(EntityPlayer player, ItemStack stack) {
        return this.landability.test(player, stack);
    }

    @Override
    public FlightApparatus.FlightState createState(Flight flight) {
        return this.vitality.apply(flight);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TravelListener flight = (p, s, d) -> {};
        private TravelListener landing = (p, s, d) -> {};
        private BiPredicate<EntityPlayer, ItemStack> usability = (p, s) -> true;
        private BiPredicate<EntityPlayer, ItemStack> landability = (p, s) -> true;
        private Function<Flight, FlightApparatus.FlightState> vitality = f -> FlightApparatus.FlightState.VOID;

        private Builder() {
        }

        public Builder withFlight(TravelListener flight) {
            this.flight = flight;
            return this;
        }

        public Builder withLanding(TravelListener landing) {
            this.landing = landing;
            return this;
        }

        public Builder withUsability(BiPredicate<EntityPlayer, ItemStack> usability) {
            this.usability = usability;
            return this;
        }

        public Builder withLandability(BiPredicate<EntityPlayer, ItemStack> landability) {
            this.landability = landability;
            return this;
        }

        public Builder withVitality(Function<Flight, FlightApparatus.FlightState> vitality) {
            this.vitality = vitality;
            return this;
        }

        public SimpleFlightApparatus build() {
            return new SimpleFlightApparatus(this.flight, this.landing, this.usability, this.landability, this.vitality);
        }
    }

    @FunctionalInterface
    public static interface TravelListener {
        public void onTravel(EntityPlayer var1, ItemStack var2, Vec3d var3);
    }
}

