/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.apparatus;

import java.util.Arrays;
import javax.annotation.Nullable;
import me.paulf.wings.WingsMod;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.config.WingsConfig;
import me.paulf.wings.util.CapabilityHolder;
import me.paulf.wings.util.CapabilityProviders;
import me.paulf.wings.util.HandlerSlot;
import me.paulf.wings.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public final class FlightApparatuses {
    private static final CapabilityHolder<ItemStack, FlightApparatus, WingedState> HOLDER = CapabilityHolder.create(() -> new WingedAbsentState(), x$0 -> new WingedPresentState((Capability)x$0));

    private FlightApparatuses() {
    }

    public static boolean has(ItemStack stack) {
        return HOLDER.state().has(stack, null);
    }

    @Nullable
    public static FlightApparatus get(ItemStack stack) {
        return (FlightApparatus)HOLDER.state().get(stack, null);
    }

    public static <T extends FlightApparatus> CapabilityProviders.NonSerializingSingleBuilder<T> providerBuilder(T instance) {
        return HOLDER.state().providerBuilder(instance);
    }

    public static ItemStack find(EntityPlayer player) {
        return HOLDER.state().find(player);
    }

    @CapabilityInject(value=FlightApparatus.class)
    static void inject(Capability<FlightApparatus> capability) {
        HOLDER.inject(capability);
    }

    private static final class WingedPresentState
    extends CapabilityHolder.PresentState<ItemStack, FlightApparatus>
    implements WingedState {
        private WingedPresentState(Capability<FlightApparatus> capability) {
            super(capability);
        }

        @Override
        public ItemStack find(EntityPlayer player) {
            for (HandlerSlot slot : WingsMod.instance().getWingsAccessor().enumerate(player)) {
                ItemStack stack = slot.get();
                if (this.has(stack, null)) {
                    return stack;
                }
                if (stack.func_190926_b() || !Arrays.asList(WingsConfig.wearObstructions).contains(Util.getName(stack.func_77973_b()).toString())) continue;
                break;
            }
            return ItemStack.field_190927_a;
        }
    }

    private static final class WingedAbsentState
    extends CapabilityHolder.AbsentState<ItemStack, FlightApparatus>
    implements WingedState {
        private WingedAbsentState() {
        }

        @Override
        public ItemStack find(EntityPlayer player) {
            return ItemStack.field_190927_a;
        }
    }

    private static interface WingedState
    extends CapabilityHolder.State<ItemStack, FlightApparatus> {
        public ItemStack find(EntityPlayer var1);
    }
}

