/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server;

import me.paulf.wings.server.apparatus.FlightApparatuses;
import me.paulf.wings.server.asm.GetLivingHeadLimitEvent;
import me.paulf.wings.server.asm.PlayerFlightCheckEvent;
import me.paulf.wings.server.asm.PlayerFlownEvent;
import me.paulf.wings.server.flight.ConstructWingsAccessorEvent;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.util.ItemPlacing;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="wings")
public final class ServerEventHandler {
    private ServerEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        EnumHand hand = event.getHand();
        ItemStack stack = player.func_184586_b(hand);
        if (event.getTarget() instanceof EntityBat && stack.func_77973_b() == Items.field_151069_bo) {
            StatBase useStat;
            player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ItemStack destroyed = stack.func_77946_l();
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if ((useStat = StatList.func_188057_b((Item)Items.field_151069_bo)) != null) {
                player.func_71029_a(useStat);
            }
            ItemStack batBlood = new ItemStack(WingsItems.BAT_BLOOD);
            if (stack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)destroyed, (EnumHand)hand);
                player.func_184611_a(hand, batBlood);
            } else if (!player.field_71071_by.func_70441_a(batBlood)) {
                player.func_71019_a(batBlood, false);
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        if (event.isMounting()) {
            Flights.ifPlayer(event.getEntityMounting(), (player, flight) -> {
                if (flight.isFlying()) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Flight flight;
        if (event.phase == TickEvent.Phase.END && (flight = Flights.get(event.player)) != null) {
            flight.tick(event.player, FlightApparatuses.find(event.player));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Flights.ifPlayer((Entity)event.getEntityLiving(), (player, flight) -> flight.setIsFlying(false, Flight.PlayerSet.ofAll()));
    }

    @SubscribeEvent
    public static void onPlayerFlightCheck(PlayerFlightCheckEvent event) {
        Flight flight = Flights.get(event.getEntityPlayer());
        if (flight != null && flight.isFlying()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerFlown(PlayerFlownEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        Flight flight = Flights.get(player);
        if (flight != null) {
            flight.onFlown(player, FlightApparatuses.find(event.getEntityPlayer()), event.getDirection());
        }
    }

    @SubscribeEvent
    public static void onGetLivingHeadLimit(GetLivingHeadLimitEvent event) {
        Flights.ifPlayer((Entity)event.getEntityLiving(), (player, flight) -> {
            if (flight.isFlying()) {
                event.setHardLimit(50.0f);
                event.disableSoftLimit();
            }
        });
    }

    @SubscribeEvent
    public static void onConstructWingsAccessor(ConstructWingsAccessorEvent event) {
        event.addPlacing(ItemPlacing.forArmor(EntityEquipmentSlot.CHEST));
    }
}

