/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.flight;

import me.paulf.wings.client.flight.Animator;
import me.paulf.wings.util.Mth;
import net.minecraft.util.math.Vec3d;

public final class AnimatorInsectoid
implements Animator {
    private static final float IDLE_FLAP_RATE = 0.05f;
    private static final float LIFT_FLAP_RATE = 1.2f;
    private float targetFlapRate = 0.05f;
    private float flapRate;
    private float prevFlapCycle;
    private float flapCycle;

    @Override
    public void beginLand() {
        this.beginLift();
    }

    @Override
    public void beginGlide() {
        this.beginLift();
    }

    @Override
    public void beginIdle() {
        this.targetFlapRate = 0.05f;
    }

    @Override
    public void beginLift() {
        this.targetFlapRate = 1.2f;
    }

    @Override
    public void beginFall() {
        this.beginIdle();
    }

    public Vec3d getRotation(float delta) {
        return new Vec3d(0.0, Math.sin(Mth.lerp(this.prevFlapCycle, this.flapCycle, delta)) * 35.0 - 42.0, 0.0);
    }

    @Override
    public void update() {
        this.prevFlapCycle = this.flapCycle;
        this.flapCycle += this.flapRate;
        this.flapRate += (this.targetFlapRate - this.flapRate) * 0.4f;
    }
}

