/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.debug;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.server.item.WingsItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="wings")
public final class DebugFlightAnimation {
    private static State state = new DisabledState();

    private DebugFlightAnimation() {
    }

    @SubscribeEvent
    public static void init(ModelRegistryEvent event) {
        state = state.init();
    }

    private static final class Handler {
        private static final GameProfile PROFILE = new GameProfile(UUID.fromString("617ab577-0da7-4d6a-a80d-0b516544369d"), "ModDeveloper");
        private EntityPlayer player;

        private Handler() {
        }

        @SubscribeEvent
        public void tick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Minecraft mc = Minecraft.func_71410_x();
                WorldClient world = mc.field_71441_e;
                if (world != null && (this.player == null || this.player.field_70170_p != world)) {
                    this.player = new EntityOtherPlayerMP((World)world, PROFILE){
                        {
                            super(x0, x1);
                            this.func_184212_Q().func_187227_b(field_184827_bp, (Object)-1);
                        }
                    };
                    this.player.func_145769_d(-this.player.func_145782_y());
                    this.player.func_70107_b(0.0, 62.0, 0.0);
                    this.player.field_70166_s = -1.0;
                    this.player.field_70167_r = 63.0;
                    Item item = WingsItems.ANGEL_WINGS;
                    this.player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(item));
                    item.func_77659_a((World)world, this.player, EnumHand.MAIN_HAND);
                    Flight flight = Flights.get(this.player);
                    if (flight != null) {
                        flight.setIsFlying(true);
                    }
                    IntHashMap entities = (IntHashMap)ReflectionHelper.getPrivateValue(World.class, (Object)world, (String[])new String[]{"entitiesById"});
                    entities.func_76038_a(this.player.func_145782_y(), (Object)this.player);
                }
                if (this.player != null && mc.func_147114_u() != null) {
                    ++this.player.field_70173_aa;
                    this.player.func_70071_h_();
                }
            }
        }

        @SubscribeEvent
        public void render(RenderWorldLastEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager manager = mc.func_175598_ae();
            if (mc.field_71441_e != null && mc.field_71439_g != null && manager.field_78734_h != null) {
                GlStateManager.func_179127_m();
                RenderHelper.func_74519_b();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                manager.func_188391_a((Entity)this.player, this.player.field_70165_t - TileEntityRendererDispatcher.field_147554_b, this.player.field_70163_u - TileEntityRendererDispatcher.field_147555_c, this.player.field_70161_v - TileEntityRendererDispatcher.field_147552_d, 0.0f, event.getPartialTicks(), false);
                RenderHelper.func_74518_a();
                GlStateManager.func_179106_n();
            }
        }
    }

    private static final class EnableState
    implements State {
        private EnableState() {
        }

        @Override
        public State init() {
            MinecraftForge.EVENT_BUS.register((Object)new Handler());
            return new EnabledState();
        }
    }

    private static final class EnabledState
    implements State {
        private EnabledState() {
        }

        @Override
        public State init() {
            return this;
        }
    }

    protected static final class DisabledState
    implements State {
        protected DisabledState() {
        }

        @Override
        public State init() {
            return this;
        }
    }

    private static interface State {
        public State init();
    }
}

