/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client;

import me.paulf.wings.client.audio.WingsSound;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.flight.FlightViews;
import me.paulf.wings.server.apparatus.FlightApparatuses;
import me.paulf.wings.server.asm.EmptyOffHandPresentEvent;
import me.paulf.wings.server.asm.GetCameraEyeHeightEvent;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.util.Mth;
import net.ilexiconn.llibrary.client.event.ApplyRenderRotationsEvent;
import net.ilexiconn.llibrary.client.event.PlayerModelEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="wings")
public final class ClientEventHandler {
    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void onSetRotationAngles(PlayerModelEvent.SetRotationAngles event) {
        EntityPlayer player = event.getEntityPlayer();
        float delta = event.getRotation() - (float)player.field_70173_aa;
        Flight flight = Flights.get(player);
        if (flight != null) {
            float f;
            float amt = flight.getFlyingAmount(delta);
            if (f > 0.0f) {
                ModelBiped model = event.getModel();
                float pitch = event.getRotationPitch();
                model.field_78116_c.field_78795_f = Mth.toRadians(Mth.lerp(pitch, pitch / 4.0f - 90.0f, amt));
                model.field_178724_i.field_78795_f = Mth.lerp(model.field_178724_i.field_78795_f, -3.2f, amt);
                model.field_178723_h.field_78795_f = Mth.lerp(model.field_178723_h.field_78795_f, -3.2f, amt);
                model.field_178722_k.field_78795_f = Mth.lerp(model.field_178722_k.field_78795_f, 0.0f, amt);
                model.field_178721_j.field_78795_f = Mth.lerp(model.field_178721_j.field_78795_f, 0.0f, amt);
                ModelBase.func_178685_a((ModelRenderer)model.field_78116_c, (ModelRenderer)model.field_178720_f);
                if (model instanceof ModelPlayer) {
                    ModelPlayer playerModel = (ModelPlayer)model;
                    ModelBase.func_178685_a((ModelRenderer)playerModel.field_178722_k, (ModelRenderer)playerModel.field_178733_c);
                    ModelBase.func_178685_a((ModelRenderer)playerModel.field_178721_j, (ModelRenderer)playerModel.field_178731_d);
                    ModelBase.func_178685_a((ModelRenderer)playerModel.field_178724_i, (ModelRenderer)playerModel.field_178734_a);
                    ModelBase.func_178685_a((ModelRenderer)playerModel.field_178723_h, (ModelRenderer)playerModel.field_178732_b);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onApplyRenderRotations(ApplyRenderRotationsEvent.Post event) {
        Flights.ifPlayer((Entity)event.getEntity(), (player, flight) -> {
            float delta = event.getPartialTicks();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = Mth.lerpDegrees(player.field_70760_ar - player.field_70126_B, player.field_70761_aq - player.field_70177_z, delta);
                float pitch = -Mth.lerpDegrees(player.field_70127_C, player.field_70125_A, delta) - 90.0f;
                GlStateManager.func_179114_b((float)Mth.lerpDegrees(0.0f, roll, amt), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)Mth.lerpDegrees(0.0f, pitch, amt), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-1.2f * Mth.easeInOut(amt)), (float)0.0f);
            }
        });
    }

    @SubscribeEvent
    public static void onGetCameraEyeHeight(GetCameraEyeHeightEvent event) {
        FlightView flight;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractClientPlayer && (flight = FlightViews.get((AbstractClientPlayer)entity)) != null) {
            flight.tickEyeHeight(event.getValue(), event.getDelta(), event::setValue);
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Flights.ifPlayer(event.getEntity(), (player, flight) -> {
            float delta = (float)event.getRenderPartialTicks();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = Mth.lerpDegrees(player.field_70760_ar - player.field_70126_B, player.field_70761_aq - player.field_70177_z, delta);
                event.setRoll(Mth.lerpDegrees(0.0f, -roll * 0.25f, amt));
            }
        });
    }

    @SubscribeEvent
    public static void onEmptyOffHandPresentEvent(EmptyOffHandPresentEvent event) {
        Flight flight = Flights.get((EntityPlayer)event.getPlayer());
        if (flight != null && flight.getFlyingAmount(1.0f) > 0.0f) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Flights.ifPlayer(event.getEntity(), EntityPlayer::func_175144_cb, (player, flight) -> Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new WingsSound((EntityPlayer)player, (Flight)flight)));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AbstractClientPlayer player;
        FlightView flight;
        EntityPlayer entity;
        if (event.phase == TickEvent.Phase.END && (entity = event.player) instanceof AbstractClientPlayer && (flight = FlightViews.get(player = (AbstractClientPlayer)entity)) != null) {
            flight.tick((EntityPlayer)player, FlightApparatuses.find((EntityPlayer)player));
        }
    }
}

