/*
 * Decompiled with CFR 0.152.
 */
package com.ldshadowlady.customcraftingtables.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class Util {
    private static final Converter<String, String> UNDRSCR_TO_CML = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);

    private Util() {
    }

    public static String underScoreToCamel(String value) {
        return (String)UNDRSCR_TO_CML.convert((Object)value);
    }

    public static <I extends Item> I name(I item, String registryName) {
        return Util.name(item, registryName, arg_0 -> item.func_77655_b(arg_0));
    }

    public static <B extends Block> B name(B block, String registryName) {
        return Util.name(block, registryName, arg_0 -> block.func_149663_c(arg_0));
    }

    private static <T extends IForgeRegistryEntry.Impl<? super T>> T name(T entry, String registryName, Consumer<String> unlocalizedNameSetter) {
        entry.setRegistryName(registryName);
        unlocalizedNameSetter.accept(Util.underScoreToCamel(registryName));
        return entry;
    }

    public static <S> void ifPlayer(@Nullable S object, Consumer<? super EntityPlayer> action) {
        Util.ifIs(object, EntityPlayer.class, action);
    }

    public static <S> void ifPlayer(@Nullable S object, Predicate<S> condition, Consumer<? super EntityPlayer> action) {
        Util.ifIs(object, condition, EntityPlayer.class, action);
    }

    public static <S, T> void ifIs(@Nullable S object, Class<T> typeClass, Consumer<? super T> action) {
        Util.ifIs(object, s -> true, typeClass, action);
    }

    public static <S, T> void ifIs(@Nullable S object, Predicate<S> condition, Class<T> typeClass, Consumer<? super T> action) {
        if (object != null && typeClass.isAssignableFrom(object.getClass()) && condition.test(object)) {
            action.accept(object);
        }
    }

    public static boolean addDescription(Item item, List<String> lines) {
        return Util.addDescription(item.func_77658_a() + ".desc", lines);
    }

    public static boolean addDescription(String keyPrefix, List<String> lines) {
        return Util.addDescription(keyPrefix, lines::add);
    }

    public static boolean addDescription(String keyPrefix, Consumer<String> action) {
        String key;
        boolean hasDescription = false;
        int i = 0;
        while (I18n.func_188566_a((String)(key = keyPrefix + "." + i))) {
            action.accept(I18n.func_135052_a((String)key, (Object[])new Object[0]));
            hasDescription = true;
            ++i;
        }
        return hasDescription;
    }

    public static <T> T withEventWatcher(T eventWatcher, Runnable runnable) {
        try {
            MinecraftForge.EVENT_BUS.register(eventWatcher);
            runnable.run();
        }
        finally {
            MinecraftForge.EVENT_BUS.unregister(eventWatcher);
        }
        return eventWatcher;
    }
}

