/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.elementium;

import de.melanx.aiotbotania.items.ToolMaterials;
import de.melanx.aiotbotania.items.base.ItemAIOTBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPixieSpawner;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemElementiumAIOT
extends ItemAIOTBase
implements IPixieSpawner {
    private static final int MANA_PER_DAMAGE = 66;

    public ItemElementiumAIOT() {
        super("elementiumAIOT", ToolMaterials.elementiumAIOTMaterial, 6.0f, -2.2f, 66, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public float getPixieChance(ItemStack stack) {
        return 0.1f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (!ToolCommons.materialsShovel.contains(mat)) {
            return false;
        }
        RayTraceResult block = ToolCommons.raytraceFromEntity((World)world, (Entity)player, (boolean)true, (double)10.0);
        if (block == null) {
            return false;
        }
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean silk = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        Block blk = world.func_180495_p(pos).func_177230_c();
        if (blk instanceof BlockFalling) {
            ToolCommons.removeBlocksInIteration((EntityPlayer)player, (ItemStack)stack, (World)world, (BlockPos)pos, (Vec3i)new Vec3i(0, -12, 0), (Vec3i)new Vec3i(1, 12, 1), state -> state.func_177230_c() == blk, (boolean)false);
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        ItemStack weapon;
        if (event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer && !(weapon = ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && weapon.func_77973_b() == this) {
            Random rand = event.getEntityLiving().field_70170_p.field_73012_v;
            int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)weapon);
            if (event.getEntityLiving() instanceof AbstractSkeleton && rand.nextInt(26) <= 3 + looting) {
                this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, event.getEntityLiving() instanceof EntityWitherSkeleton ? 1 : 0));
            } else if (event.getEntityLiving() instanceof EntityZombie && !(event.getEntityLiving() instanceof EntityPigZombie) && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 2));
            } else if (event.getEntityLiving() instanceof EntityCreeper && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 4));
            } else if (event.getEntityLiving() instanceof EntityPlayer && rand.nextInt(11) <= 1 + looting) {
                ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
                ItemNBTHelper.setString((ItemStack)stack, (String)"SkullOwner", (String)event.getEntityLiving().func_70005_c_());
                this.addDrop(event, stack);
            } else if (event.getEntityLiving() instanceof EntityDoppleganger && rand.nextInt(13) < 1 + looting) {
                this.addDrop(event, new ItemStack(ModItems.gaiaHead));
            }
        }
    }

    private void addDrop(LivingDropsEvent event, ItemStack drop) {
        EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, drop);
        entityitem.func_174867_a(10);
        event.getDrops().add(entityitem);
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack stack;
        if (event.getHarvester() != null && !(stack = event.getHarvester().func_184614_ca()).func_190926_b() && stack.func_77973_b() == this) {
            event.getDrops().removeIf(s -> !s.func_190926_b() && (ItemElementiumAIOT.isDisposable(s) || ItemElementiumAIOT.isSemiDisposable(s) && !event.getHarvester().func_70093_af()));
        }
    }

    public static boolean isDisposable(Block block) {
        return ItemElementiumAIOT.isDisposable(new ItemStack(block));
    }

    private static boolean isDisposable(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (!BotaniaAPI.disposableBlocks.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSemiDisposable(ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (!BotaniaAPI.semiDisposableBlocks.contains(name)) continue;
            return true;
        }
        return false;
    }
}

