/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.base;

import com.google.common.collect.Sets;
import de.melanx.aiotbotania.blocks.ModBlocks;
import de.melanx.aiotbotania.util.Registry;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;

public class ItemAIOTBase
extends ItemTool
implements IManaUsingItem {
    private int MANA_PER_DAMAGE;
    private boolean special;

    public ItemAIOTBase(String name, Item.ToolMaterial mat, float attackDamage, float attackSpeed, int MANA_PER_DAMAGE, boolean special) {
        super(attackDamage, attackSpeed, mat, new HashSet());
        this.setHarvestLevels(mat.func_77996_d());
        this.MANA_PER_DAMAGE = MANA_PER_DAMAGE;
        this.special = special;
        Registry.registerItem((Item)this, name);
        Registry.registerModel((Object)this);
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        ToolUtil.onUpdate(stack, world, player, this.MANA_PER_DAMAGE);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, @Nonnull EntityLivingBase par3EntityLivingBase) {
        return ToolUtil.hitEntity(par1ItemStack, par3EntityLivingBase, this.MANA_PER_DAMAGE);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        return ToolUtil.onBlockDestroyed(stack, world, state, pos, entity, this.MANA_PER_DAMAGE);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Block block = world.func_180495_p(pos).func_177230_c();
        boolean hoemode = ItemNBTHelper.getBoolean((ItemStack)player.func_184586_b(hand), (String)"hoemode", (boolean)true);
        if (hoemode) {
            if (!(player.func_70093_af() || block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_185774_da && block != Blocks.field_150458_ak && block != ModBlocks.superfarmland)) {
                if (this.special) {
                    return ToolUtil.hoeUse(player, world, pos, hand, side, true, false, this.MANA_PER_DAMAGE);
                }
                return ToolUtil.hoeUse(player, world, pos, hand, side, false, false, this.MANA_PER_DAMAGE);
            }
            if (side != EnumFacing.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos.func_177984_a()) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
                return ToolUtil.shovelUse(player, world, pos, hand, side, this.MANA_PER_DAMAGE);
            }
            return EnumActionResult.PASS;
        }
        if (!player.func_70093_af()) {
            return ToolUtil.pickUse(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        if (side == EnumFacing.UP) {
            return ToolUtil.axeUse(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af()) {
            ToolUtil.toggleMode(player, itemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return 15.0f;
        }
        return state.func_177230_c().getHarvestTool(state) == null || state.func_177230_c().getHarvestTool(state).isEmpty() || this.getToolClasses(stack).contains(state.func_177230_c().getHarvestTool(state)) ? this.field_77864_a : 1.0f;
    }

    @Nonnull
    public Set<String> getToolClasses(ItemStack stack) {
        return Sets.newHashSet((Object[])new String[]{"pickaxe", "axe", "shovel"});
    }

    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 0 || super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    public boolean usesMana(ItemStack itemStack) {
        return true;
    }

    private void setHarvestLevels(int amount) {
        for (String s : this.getToolClasses(null)) {
            this.setHarvestLevel(s, amount);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y.func_77557_a(Items.field_151048_u);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return state.func_185904_a().func_76229_l() || state.func_177230_c() == Blocks.field_150431_aC || state.func_177230_c() == Blocks.field_150433_aE || (state.func_177230_c() == Blocks.field_150343_Z ? this.field_77862_b.func_77996_d() >= 3 : (state.func_177230_c() != Blocks.field_150484_ah && state.func_177230_c() != Blocks.field_150482_ag ? (state.func_177230_c() != Blocks.field_150412_bA && state.func_177230_c() != Blocks.field_150475_bE ? (state.func_177230_c() != Blocks.field_150340_R && state.func_177230_c() != Blocks.field_150352_o ? (state.func_177230_c() != Blocks.field_150339_S && state.func_177230_c() != Blocks.field_150366_p ? (state.func_177230_c() != Blocks.field_150368_y && state.func_177230_c() != Blocks.field_150369_x ? (state.func_177230_c() != Blocks.field_150450_ax && state.func_177230_c() != Blocks.field_150439_ay ? state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f || state.func_185904_a() == Material.field_151574_g : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2));
    }
}

