/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.forgivingvoid.ForgivingVoidEvent;
import net.blay09.mods.forgivingvoid.ModConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="forgivingvoid", name="Forgiving Void", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";
    private static Logger logger = LogManager.getLogger((String)"forgivingvoid");
    private static List<Integer> dimensionBlacklist = Lists.newArrayList();

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ForgivingVoid.updateDimensionBlacklist();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        event.buildSoftDependProxy("gamestages", "net.blay09.mods.forgivingvoid.compat.GameStagesCompat", new Object[0]);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            boolean isTeleporting;
            boolean isInVoid = event.player.field_70163_u < (double)ModConfig.triggerAtY && event.player.field_70167_r < (double)ModConfig.triggerAtY;
            boolean bl = isTeleporting = ((EntityPlayerMP)event.player).field_71135_a.field_184362_y != null;
            if (ForgivingVoid.isEnabledForDimension(event.player.field_71093_bK) && isInVoid && !isTeleporting && ForgivingVoid.fireForgivingVoidEvent(event.player)) {
                event.player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 3));
                if (event.player.func_184207_aI()) {
                    event.player.func_184226_ay();
                }
                event.player.func_184210_p();
                ((EntityPlayerMP)event.player).field_71135_a.func_147364_a(event.player.field_70165_t, (double)ModConfig.fallingHeight, event.player.field_70161_v, event.player.field_70177_z, event.player.field_70125_A);
                event.player.getEntityData().func_74757_a("ForgivingVoidNoFallDamage", true);
            } else if (event.player.getEntityData().func_74767_n("ForgivingVoidNoFallDamage")) {
                if (event.player.func_70090_H()) {
                    event.player.getEntityData().func_74757_a("ForgivingVoidNoFallDamage", false);
                    ((EntityPlayerMP)event.player).field_184851_cj = false;
                    return;
                }
                if (ModConfig.disableVanillaAntiCheatWhileFalling) {
                    ((EntityPlayerMP)event.player).field_184851_cj = true;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && event.getEntity().getEntityData().func_74767_n("ForgivingVoidNoFallDamage")) {
            if (ModConfig.disableVanillaAntiCheatWhileFalling) {
                ((EntityPlayerMP)event.getEntity()).field_184851_cj = false;
            }
            if (!event.isCanceled()) {
                float finalDamage;
                float damage = ModConfig.damageOnFall;
                if (ModConfig.preventDeath && event.getEntityLiving().func_110143_aJ() - damage <= 0.0f) {
                    damage = event.getEntityLiving().func_110143_aJ() - 1.0f;
                }
                if ((finalDamage = damage * event.getDamageMultiplier()) > 0.0f) {
                    event.getEntity().func_70097_a(DamageSource.field_76379_h, finalDamage);
                }
            }
            event.setDamageMultiplier(0.0f);
            event.setCanceled(true);
            event.getEntity().getEntityData().func_74757_a("ForgivingVoidNoFallDamage", false);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (MOD_ID.equals(event.getModID())) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            ForgivingVoid.updateDimensionBlacklist();
        }
    }

    private static void updateDimensionBlacklist() {
        dimensionBlacklist.clear();
        for (String dimension : ModConfig.dimensionBlacklist) {
            try {
                dimensionBlacklist.add(Integer.parseInt(dimension));
            }
            catch (NumberFormatException e) {
                logger.error("Invalid dimension blacklist entry {}, expected numeric id", (Object)dimension);
            }
        }
    }

    private static boolean fireForgivingVoidEvent(EntityPlayer player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new ForgivingVoidEvent(player));
    }

    private static boolean isEnabledForDimension(int dimension) {
        if (dimension == 0) {
            return ModConfig.triggerInOverworld;
        }
        if (dimension == 1) {
            return ModConfig.triggerInEnd;
        }
        if (dimension == -1) {
            return ModConfig.triggerInNether;
        }
        return ModConfig.dimensionBlacklistIsWhitelist == dimensionBlacklist.contains(dimension);
    }
}

