/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import yuudaari.soulus.common.util.BlockFromString;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.Range;
import yuudaari.soulus.common.util.serializer.CollectionSerializer;
import yuudaari.soulus.common.util.serializer.FieldSerializer;
import yuudaari.soulus.common.util.serializer.NullableField;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@Serializable
public class OreVein {
    public static final Map<String, BiomeDictionary.Type> BIOME_TYPES;
    @Serialized
    public String block;
    @Serialized
    public String replace;
    @Serialized
    public int chances = 4;
    @Serialized
    public Range size = new Range(2, 6);
    @Serialized
    public Range height = new Range(0, 255);
    @Serialized(value=DimensionTypeSerializer.class)
    @NullableField
    public DimensionType dimension = null;
    @Serialized(value=BiomeTypeListSerializer.class)
    public List<BiomeDictionary.Type> biomeTypesWhitelist = new ArrayList<BiomeDictionary.Type>();
    @Serialized(value=BiomeTypeListSerializer.class)
    public List<BiomeDictionary.Type> biomeTypesBlacklist = new ArrayList<BiomeDictionary.Type>();

    public OreVein setBlock(String block) {
        this.block = block;
        return this;
    }

    public OreVein setToReplace(String block) {
        this.replace = block;
        return this;
    }

    public OreVein setDimension(DimensionType dimension) {
        this.dimension = dimension;
        return this;
    }

    public OreVein setSize(int min, int max) {
        this.size = new Range(min, max);
        return this;
    }

    public OreVein setChances(int chances) {
        this.chances = chances;
        return this;
    }

    public OreVein setHeight(int min, int max) {
        this.height = new Range(min, max);
        return this;
    }

    public OreVein setBiomes(BiomeDictionary.Type ... types) {
        this.biomeTypesWhitelist = Arrays.asList(types);
        return this;
    }

    public OreVein setBiomesBlacklist(BiomeDictionary.Type ... types) {
        this.biomeTypesBlacklist = Arrays.asList(types);
        return this;
    }

    public void generate(World world, Random random, int chunkX, int chunkZ) {
        if (this.chances <= 0) {
            return;
        }
        if (this.size.max <= this.size.min) {
            return;
        }
        if (this.height.max <= this.height.min) {
            return;
        }
        if (this.dimension != null && world.field_73011_w.func_186058_p() != this.dimension) {
            return;
        }
        int veinSize = this.size.min.intValue() + random.nextInt(this.size.max.intValue() - this.size.min.intValue());
        int heightRange = this.height.max.intValue() - this.height.min.intValue();
        IBlockState veinBlock = BlockFromString.get(this.block);
        IBlockState toReplace = BlockFromString.get(this.replace);
        if (veinBlock == null || toReplace == null) {
            Logger.error("Unable to generate vein of " + veinBlock + " in " + toReplace);
            return;
        }
        WorldGenMinable gen = new WorldGenMinable(veinBlock, veinSize, blockstate -> blockstate.equals(toReplace));
        for (int i = 0; i < this.chances; ++i) {
            Biome biome;
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(heightRange) + this.height.min.intValue();
            int z = chunkZ * 16 + random.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            if (this.biomeTypesWhitelist.size() > 0) {
                biome = world.func_180494_b(pos);
                if (!this.biomeTypesWhitelist.stream().anyMatch(type -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type))) break;
            }
            if (this.biomeTypesBlacklist.size() > 0) {
                biome = world.func_180494_b(pos);
                if (this.biomeTypesBlacklist.stream().anyMatch(type -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type))) break;
            }
            gen.func_180709_b(world, random, pos);
        }
    }

    static {
        try {
            Field f = BiomeDictionary.Type.class.getDeclaredField("byName");
            f.setAccessible(true);
            BIOME_TYPES = (Map)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logger.error(e);
            throw new RuntimeException("Unable to generate biome types list");
        }
    }

    public static class BiomeTypeListSerializer
    extends CollectionSerializer<BiomeDictionary.Type> {
        @Override
        public JsonElement serializeValue(BiomeDictionary.Type value) throws Exception {
            return new JsonPrimitive(value.getName());
        }

        @Override
        public BiomeDictionary.Type deserializeValue(JsonElement value) throws Exception {
            return BIOME_TYPES.get(value.getAsString());
        }
    }

    public static class DimensionTypeSerializer
    extends FieldSerializer<DimensionType> {
        @Override
        public JsonElement serialize(Class<?> objectType, DimensionType object) {
            return object == null ? JsonNull.INSTANCE : new JsonPrimitive(object.func_186065_b());
        }

        @Override
        public DimensionType deserialize(Class<?> requestedType, JsonElement element) {
            return element.isJsonNull() ? null : DimensionType.func_193417_a((String)element.getAsString());
        }
    }
}

