/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;

public class Logger {
    public static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger((String)"soulus");
    public static final Stack<String> scopes = new Stack();

    private static String getScopes() {
        return scopes.size() == 0 ? "" : "[" + String.join((CharSequence)" | ", scopes) + "] ";
    }

    public static void inScope(String scope, ScopeHandler handler) {
        scopes.push(scope);
        handler.handle();
        scopes.pop();
    }

    public static void info(String message) {
        LOGGER.info(Logger.getScopes() + message);
    }

    public static void info(String scope, String message) {
        scopes.push(scope);
        LOGGER.info(Logger.getScopes() + message);
        scopes.pop();
    }

    public static void warn(String message) {
        LOGGER.warn(Logger.getScopes() + message);
    }

    public static void warn(String scope, String message) {
        scopes.push(scope);
        LOGGER.warn(Logger.getScopes() + message);
        scopes.pop();
    }

    public static void error(String message) {
        LOGGER.error(Logger.getScopes() + message);
    }

    public static void error(String scope, String message) {
        scopes.push(scope);
        LOGGER.error(Logger.getScopes() + message);
        scopes.pop();
    }

    public static void error(Exception e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = writer.toString();
        Logger.error(stackTrace);
    }

    public static interface ScopeHandler {
        public void handle();
    }
}

