/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.registration;

import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.World;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.config.item.ConfigFood;
import yuudaari.soulus.common.registration.IBlockRegistration;
import yuudaari.soulus.common.registration.IItemRegistration;
import yuudaari.soulus.common.util.ModPotionEffect;

public class Registration {

    public static class ItemFood
    extends net.minecraft.item.ItemFood
    implements IItemRegistration {
        protected Boolean glint = false;
        private IFoodConfigGetter foodConfigGetter = null;

        public ItemFood(String name, IFoodConfigGetter configGetter) {
            super(0, false);
            this.setName(name);
            this.foodConfigGetter = configGetter;
            Soulus.onConfigReload(this::onConfigReload);
        }

        private void onConfigReload() {
            ConfigFood config = this.foodConfigGetter.get();
            this.field_77852_bZ = config.isAlwaysEdible();
        }

        public int func_150905_g(ItemStack stack) {
            return this.foodConfigGetter.get().getAmount();
        }

        public float func_150906_h(ItemStack stack) {
            return this.foodConfigGetter.get().getSaturation();
        }

        public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
            super.func_77654_b(stack, world, entity);
            for (ModPotionEffect effect : this.foodConfigGetter.get().getEffects()) {
                effect.apply(entity);
            }
            stack.func_190918_g(this.foodConfigGetter.get().getQuantity() - 1);
            return stack;
        }

        public int func_77626_a(ItemStack stack) {
            return this.foodConfigGetter.get().getDuration();
        }

        public static interface IFoodConfigGetter {
            public ConfigFood get();
        }
    }

    public static class Item
    extends net.minecraft.item.Item
    implements IItemRegistration {
        private Boolean glint = false;
        private int burnTime = 0;

        public Item(String name) {
            this.setName(name);
        }

        public Item setHasGlint() {
            this.glint = true;
            return this;
        }

        public boolean func_77636_d(ItemStack stack) {
            return this.glint;
        }

        public int getItemBurnTime(ItemStack itemStack) {
            return this.burnTime;
        }

        public Item setBurnTime(int burnTime) {
            this.burnTime = burnTime;
            return this;
        }

        @Override
        public Item setHasDescription() {
            return (Item)IItemRegistration.super.setHasDescription();
        }

        @Override
        public Item addOreDict(String ... dictionaries) {
            return (Item)IItemRegistration.super.addOreDict(dictionaries);
        }

        public Item setMaxStackSize(int maxStackSize) {
            return (Item)super.func_77625_d(maxStackSize);
        }
    }

    public static class ItemMultiTexture
    extends net.minecraft.item.ItemMultiTexture
    implements IItemRegistration {
        public ItemMultiTexture(Block block, ItemMultiTexture.Mapper mapper) {
            super((net.minecraft.block.Block)block, (net.minecraft.block.Block)block, mapper);
            this.setRegistryName(block.getRegistryName());
        }

        public ItemMultiTexture setHasSubtypes(boolean hasSubtypes) {
            return (ItemMultiTexture)super.func_77627_a(hasSubtypes);
        }
    }

    public static class ItemBlock
    extends net.minecraft.item.ItemBlock
    implements IItemRegistration {
        public ItemBlock(IBlockRegistration block) {
            super(block.getBlock());
            this.setRegistryName(block.getRegistryName());
        }

        public ItemBlock setHasSubtypes(boolean hasSubtypes) {
            return (ItemBlock)super.func_77627_a(hasSubtypes);
        }
    }

    public static class BlockPane
    extends net.minecraft.block.BlockPane
    implements IBlockRegistration {
        public BlockPane(String name, Material material) {
            super(material, true);
            this.setName(name);
        }

        public BlockPane getBlock() {
            return this;
        }

        @Override
        public BlockPane setHasItem() {
            return (BlockPane)IBlockRegistration.super.setHasItem();
        }
    }

    public static class BlockPillar
    extends BlockRotatedPillar
    implements IBlockRegistration {
        public BlockPillar(String name, Material material) {
            super(material);
            this.setName(name);
        }

        public BlockPillar getBlock() {
            return this;
        }

        @Override
        public BlockPillar setHasItem() {
            return (BlockPillar)IBlockRegistration.super.setHasItem();
        }

        @Override
        public BlockPillar setHasDescription() {
            return (BlockPillar)IBlockRegistration.super.setHasDescription();
        }

        public BlockRenderLayer func_180664_k() {
            Material material = this.func_149688_o(null);
            if (material.func_76218_k()) {
                return BlockRenderLayer.SOLID;
            }
            if (material.func_76228_b()) {
                return BlockRenderLayer.TRANSLUCENT;
            }
            return BlockRenderLayer.CUTOUT;
        }

        public boolean func_149662_c(IBlockState state) {
            Material material = this.func_149688_o(null);
            return material.func_76218_k() && material.func_76228_b();
        }
    }

    public static class Block
    extends net.minecraft.block.Block
    implements IBlockRegistration {
        public Block(String name, Material material) {
            super(material);
            this.setName(name);
        }

        @Override
        public Block getBlock() {
            return this;
        }

        @Override
        public Block setHasItem() {
            return (Block)IBlockRegistration.super.setHasItem();
        }

        @Override
        public Block setHasDescription() {
            return (Block)IBlockRegistration.super.setHasDescription();
        }

        public BlockRenderLayer func_180664_k() {
            Material material = this.func_149688_o(null);
            if (material.func_76218_k()) {
                return BlockRenderLayer.SOLID;
            }
            if (material.func_76228_b()) {
                return BlockRenderLayer.TRANSLUCENT;
            }
            return BlockRenderLayer.CUTOUT;
        }

        public boolean func_149662_c(IBlockState state) {
            Material material = this.func_149688_o(null);
            return material.func_76218_k() && material.func_76228_b();
        }
    }
}

